package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.impl.ProtobufSchemaGenerator;
import com.github.krr.schema.generator.protobuf.model.MessageNodeBuilder;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.ProtoPrimitiveMessageNode;
import org.springframework.util.ClassUtils;

@SuppressWarnings("rawtypes")
public class PrimitiveMessageModelNodeBuilder extends AbstractMessageModelNodeBuilder {

  @Override
  public AbstractMessageNode buildNode(MessageNodeBuilder messageNodeBuilder,
                                       TypeNode typeNode,
                                       ProtobufSchemaGenerator.ProtoSyntax syntax) {
    Class clazz = (Class) typeNode.getType();
    ProtoPrimitiveMessageNode node = new ProtoPrimitiveMessageNode(typeNode.getName(), clazz);
    messageNodeBuilder.registerMessage(clazz.getName(), node);
    return node;
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    try {
      Class clazz = (Class) typeNode.getType();
      return ClassUtils.isPrimitiveOrWrapper(clazz) || clazz == String.class;
    }
    catch(Exception e) {
      return false;
    }
  }

}
