package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.ProtoPrimitiveAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.ProtoPrimitiveSyntheticAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.SyntheticAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractSyntheticMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.ProtoPrimitiveCollectionMessageNode;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

@SuppressWarnings("rawtypes")
public class ProtoPrimitiveCollectionParameterizedMessageNodeBuilder extends CollectionParameterizedMessageNodeBuilder {

  @Override
  protected AbstractSyntheticMessageNode getMessageNodeInstance(TypeNode typeNode, AbstractMessageNode valueMessageNode, ParameterizedType type) {
    ProtoPrimitiveCollectionMessageNode node = new ProtoPrimitiveCollectionMessageNode(typeNode.getName(), type);
    SyntheticAttribute attribute = new ProtoPrimitiveSyntheticAttribute(ITEMS, getItemType(node), 10);
    attribute.setTypeMessageNode(node);
    attribute.setContainingMessageNode(valueMessageNode);
    attribute.setCollectionAttr(true);
    node.setProtoMessageName(typeNode.getName());
    node.setWrappedMessage(valueMessageNode);
    node.addAttribute(attribute);
    return node;
  }

  @Override
  protected String getItemType(AbstractMessageNode messageNode) {
    ProtoPrimitiveCollectionMessageNode collectionMessageNode = (ProtoPrimitiveCollectionMessageNode) messageNode;
    Class javaType = (Class) ((ParameterizedType)collectionMessageNode.getJavaType()).getActualTypeArguments()[0];
    if(!javaType.isEnum()) {
      return String.format("repeated %s", ProtoPrimitiveAttribute.PROTO_PRIMITIVE_TYPE_MAP.get(javaType));
    }
    else {
      return String.format("repeated %s", getProtoCompatibleName(javaType.getName()));
    }
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    boolean isCollectionType = super.supports(typeNode);
    if(!isCollectionType) {
      return false;
    }
    Type type = getActualTypeArgument((ParameterizedType) typeNode.getType());
    // is this a collection of primitive types.
    return isProtoPrimitive(type) ||isEnum(type) ;
  }
}
