package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.ProtoPrimitiveAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.ProtoPrimitiveSyntheticAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.SyntheticAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractSyntheticMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.ProtoPrimitiveMapMessageNode;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

@SuppressWarnings("rawtypes")
public class ProtoPrimitiveMapParameterizedMessageNodeBuilder extends MapParameterizedMessageNodeBuilder {

  @Override
  protected AbstractSyntheticMessageNode getMessageNodeInstance(TypeNode typeNode, AbstractMessageNode valueMessageNode, ParameterizedType type) {
    String name = typeNode.getName();
    ProtoPrimitiveMapMessageNode node = new ProtoPrimitiveMapMessageNode(name, type);
    SyntheticAttribute attribute = new ProtoPrimitiveSyntheticAttribute(KVPAIRS, getItemType(node), 10);
    attribute.setTypeMessageNode(node);
    attribute.setMapAttr(true);
    attribute.setContainingMessageNode(valueMessageNode);
    node.addAttribute(attribute);
    node.setWrappedMessage(valueMessageNode);
    node.setProtoMessageName(name);
    return node;
  }

  @Override
  protected String getItemType(AbstractMessageNode messageNode) {
    ProtoPrimitiveMapMessageNode mapMessageNode = (ProtoPrimitiveMapMessageNode) messageNode;
    Class javaType = (Class) ((ParameterizedType)mapMessageNode.getJavaType()).getActualTypeArguments()[1];
    return String.format("map<string, %s>", ProtoPrimitiveAttribute.PROTO_PRIMITIVE_TYPE_MAP.get(javaType));
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    boolean isMapType = super.supports(typeNode);
    if(!isMapType) {
      return false;
    }
    Type type = getActualTypeArgument((ParameterizedType) typeNode.getType());
    // is this a collection of primitive types.
    return isProtoPrimitive(type);
  }

}
