package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.impl.ProtobufSchemaGenerator;
import com.github.krr.schema.generator.protobuf.model.MessageNodeBuilder;
import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractSyntheticMessageNode;
import org.springframework.util.Assert;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

@SuppressWarnings("rawtypes")
public class TypeVariableMessageNodeBuilder extends AbstractMessageModelNodeBuilder {

  @Override
  public AbstractMessageNode buildNode(MessageNodeBuilder messageNodeBuilder,
                                       TypeNode typeNode,
                                       ProtobufSchemaGenerator.ProtoSyntax syntax) {
    TypeVariable typeVariable = (TypeVariable) typeNode.getType();
    Type bound = typeVariable.getBounds()[0];
    // create the message nodes for the bounds and the generic declaration
    // safe to cast this to class since the other implementations of this interface
    // are not something we will get here.
    String key = AbstractSyntheticMessageNode.getKey(bound);
    AbstractMessageNode boundMessageNode = messageNodeBuilder.build(new TypeNode(key, bound), syntax);
    Assert.notNull(boundMessageNode, "Could not create message node for type" + typeNode);
    return boundMessageNode;
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    Type type = typeNode.getType();
    // this builder only gets called when a type variable is assigned to an attribute
    // only one type variable can be assigned.
    return type instanceof TypeVariable && ((TypeVariable<?>) type).getBounds().length == 1;
  }
}
