package com.github.krr.schema.generator.protobuf.model.builders;

import com.github.krr.schema.generator.protobuf.impl.ProtobufSchemaGenerator;
import com.github.krr.schema.generator.protobuf.model.MessageNodeBuilder;
import com.github.krr.schema.generator.protobuf.model.nodes.TypeNode;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import org.springframework.util.Assert;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

public class WildcardTypeImplMessageNodeBuilder extends AbstractMessageModelNodeBuilder {

  @Override
  public AbstractMessageNode buildNode(MessageNodeBuilder messageNodeBuilder, TypeNode type, ProtobufSchemaGenerator.ProtoSyntax syntax) {
    WildcardType wildcardType = (WildcardType) type.getType();
    Type[] upperBounds = wildcardType.getUpperBounds();
    Assert.isTrue(upperBounds.length == 1, "Only supported for a single wildcard parameter " + wildcardType);

    return messageNodeBuilder.build(new TypeNode(type.getName(), upperBounds[0]), syntax);
  }

  @Override
  public boolean supports(TypeNode typeNode) {
    return typeNode.getType() instanceof WildcardType;
  }
}
