package com.github.krr.schema.generator.protobuf.model.nodes.attributes;

import com.github.krr.schema.generator.protobuf.impl.ProtobufSchemaGenerator.ProtoSyntax;
import com.github.krr.schema.generator.protobuf.model.nodes.messages.AbstractMessageNode;
import lombok.*;

@SuppressWarnings("unused")
@Data
@ToString(onlyExplicitlyIncluded = true)
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
public abstract class AbstractAttribute {

  @ToString.Include
  @EqualsAndHashCode.Include
  protected String name;

  protected String type;

  protected long index;

  @Getter
  @Setter
  protected ProtoSyntax syntax;

  @Getter
  @Setter
  protected boolean iterableAttr;

  /**
   * The message node that this attribute belongs to.
   */
  protected AbstractMessageNode containingMessageNode;

  /**
   * The message node for the type of this attribute
   */
  protected AbstractMessageNode typeMessageNode;

  public AbstractAttribute(String name, String type, long index) {
    this.name = name;
    this.type = type;
    this.index = index;
  }

  public boolean isOptional() {
    return syntax == ProtoSyntax.PROTO2;
  }

  public String getDifferTemplate() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public String getBeanItemJavaType() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public String getProtoItemJavaType() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public boolean isSuperclassAttribute() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public boolean isAbstract() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

}
