package com.github.krr.schema.generator.protobuf.model.nodes.attributes;

import com.github.krr.schema.generator.protobuf.models.TypeInfo;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("unused")
public class JavaAttribute extends AbstractAttribute {

  public static final Map<String, String> SIMPLE_DIFFER_LOOKUP = new HashMap<>();
  
  static {
    SIMPLE_DIFFER_LOOKUP.put("string", "STRING_DIFFER");
    SIMPLE_DIFFER_LOOKUP.put("boolean", "BOOLEAN_DIFFER");
    SIMPLE_DIFFER_LOOKUP.put("int64", "LONG_DIFFER");
    SIMPLE_DIFFER_LOOKUP.put("int32", "INTEGER_DIFFER");
    SIMPLE_DIFFER_LOOKUP.put("float", "FLOAT_DIFFER");
    SIMPLE_DIFFER_LOOKUP.put("double", "DOUBLE_DIFFER");
  }
  
  @Getter
  private final TypeInfo typeInfo;

  @Getter
  protected Type beanType;

  public JavaAttribute(String name, String type, Type clazz, long index) {
    super(name, type, index);
    this.beanType = clazz;
    this.typeInfo = new TypeInfo();
    TypeInfo.updateTypeInfoForType(this.typeInfo, clazz);
  }

  public boolean isSuperclassAttribute() {
    return false;
  }

  @Override
  public String getType() {
    // We only know if a wrapper message is visible after
    // the entire graph is processed.  If the type of this
    // attribute turns out to not have a wrapper after all
    // the processing is complete we have to get the attribute name
    // from the wrapped class
    if(typeMessageNode != null && !typeMessageNode.isModelVisible()) {
      return typeMessageNode.getWrappedAttributeType();
    }
    return type;
  }

  @Override
  public boolean isOptional() {
    if(typeMessageNode != null && typeMessageNode.isModelVisible()) {
      return true;
    }
    return super.isOptional() && !iterableAttr;
  }

  public boolean isBoolean() {
    return typeInfo.isBoolean();
  }

  public String getAttributeJavaType() {
    return beanType.getTypeName().replaceAll("\\$", ".");
  }

  public String getDifferJavaType() {
    return String.format("%sDiffer", beanType.getTypeName().replaceAll("\\$", "Dollar"));
  }

  @Override
  public String getDifferTemplate() {
    return "differs1/simple";
  }

  public String getProperty() {
    return StringUtils.capitalize(name);
  }

  public String getBeanGetterMethod() {
    return String.format("get%s()", StringUtils.capitalize(name));
  }

  public boolean isSimpleComparator() {
    return typeInfo.isPrimitiveOrStringOrObject();
  }

  public String getDifferInstance() {
    if(isSimpleComparator()) {
      return SIMPLE_DIFFER_LOOKUP.get(type);
    }
    return String.format("new %s();", getDifferJavaType());
  }

  public String getDifferName() {
    return String.format("_%sDiffer", name);
  }

  public boolean isOwnProperty() {
    return true;
  }

  public String getBeanItemJavaType() {
    if(typeMessageNode.isModelVisible()) {
      return typeMessageNode.getBeanItemJavaType();
    }
    if(typeMessageNode.getWrappedMessage() != null) {
      return typeMessageNode.getWrappedMessage().getBeanItemJavaType();
    }
    throw new UnsupportedOperationException("Wrapped message was null");
  }

  public String getProtoItemJavaType() {
    if(typeMessageNode.isModelVisible()) {
      return typeMessageNode.getProtoItemJavaType();
    }
    return typeMessageNode.getWrappedMessage().getProtoItemJavaType();
  }


}
