package com.github.krr.schema.generator.protobuf.model.nodes.attributes;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("rawtypes")
public class ProtoPrimitiveAttribute extends JavaAttribute {

  public static final Map<Class, String> PROTO_PRIMITIVE_TYPE_MAP = new HashMap<>();

  static {
    PROTO_PRIMITIVE_TYPE_MAP.put(String.class, "string");
    PROTO_PRIMITIVE_TYPE_MAP.put(Integer.class, "int32");
    PROTO_PRIMITIVE_TYPE_MAP.put(int.class, "int32");
    PROTO_PRIMITIVE_TYPE_MAP.put(int[].class, "repeated int32");
    PROTO_PRIMITIVE_TYPE_MAP.put(Long.class, "int64");
    PROTO_PRIMITIVE_TYPE_MAP.put(long.class, "int64");
    PROTO_PRIMITIVE_TYPE_MAP.put(long[].class, "repeated int64");
    PROTO_PRIMITIVE_TYPE_MAP.put(Double.class, "double");
    PROTO_PRIMITIVE_TYPE_MAP.put(Number.class, "double");
    PROTO_PRIMITIVE_TYPE_MAP.put(double.class, "double");
    PROTO_PRIMITIVE_TYPE_MAP.put(double[].class, "repeated double");
    PROTO_PRIMITIVE_TYPE_MAP.put(Float.class, "float");
    PROTO_PRIMITIVE_TYPE_MAP.put(float.class, "float");
    PROTO_PRIMITIVE_TYPE_MAP.put(float[].class, "repeated float");
    PROTO_PRIMITIVE_TYPE_MAP.put(byte[].class, "bytes");
    PROTO_PRIMITIVE_TYPE_MAP.put(Boolean.class, "bool");
    PROTO_PRIMITIVE_TYPE_MAP.put(boolean.class, "bool");
    PROTO_PRIMITIVE_TYPE_MAP.put(boolean[].class, "repeated bool");
  }

  public ProtoPrimitiveAttribute(String name, Class clazz, long index) {
    super(name, PROTO_PRIMITIVE_TYPE_MAP.get(clazz), clazz, index);
  }

  @Override
  public String getType() {
    return type;
  }

  @Override
  public String getDifferTemplate() {
    return "differs1/simple";
  }
}
