package com.github.krr.schema.generator.protobuf.model.nodes.attributes;

import com.github.krr.schema.generator.protobuf.mappercodegen.MapperConfig;
import lombok.Getter;
import lombok.Setter;

public class SyntheticAttribute extends AbstractAttribute {

  @Getter @Setter
  private boolean collectionAttr;

  @Getter @Setter
  private boolean mapAttr;

  public SyntheticAttribute(String name, String type, long index) {
    super(name, type, index);
  }

  public String getBeanJavaType() {
    String beanJavaType = typeMessageNode.getBeanJavaType();
    if(mapAttr) {
      return String.format("java.util.Map<String, %s>", beanJavaType);
    }
    else if(collectionAttr) {
      return String.format("java.util.List<%s>", beanJavaType);
    }
    return beanJavaType;
  }

  public String getProtoJavaType(MapperConfig mapperConfig) {
    return typeMessageNode.getProtoJavaType(mapperConfig);
  }
}
