package com.github.krr.schema.generator.protobuf.model.nodes.messages;

import com.github.krr.schema.generator.protobuf.api.MessageNode;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.AbstractAttribute;
import com.github.krr.schema.generator.protobuf.model.nodes.attributes.SyntheticAttribute;
import com.github.krr.schema.generator.protobuf.mappercodegen.MapperConfig;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SuppressWarnings("unused")
@ToString(onlyExplicitlyIncluded = true)
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
public abstract class AbstractMessageNode implements MessageNode {

  @ToString.Include
  @Getter
  @EqualsAndHashCode.Include
  protected final String name;

  /**
   * The identifier used in for this message.  Used in templates.
   */
  @ToString.Include
  @Getter
  @Setter
  protected String protoMessageName;

  /**
   * Not null if this message node wraps another message.
   */
  @Getter @Setter
  protected AbstractMessageNode wrappedMessage;

  @Getter
  protected final List<AbstractAttribute> attributes = new ArrayList<>();

  protected AbstractMessageNode(String name) {
    this.name = name;
  }

  public void addAttribute(AbstractAttribute attribute) {
    attributes.add(attribute);
  }

  public void addAttributes(Collection<AbstractAttribute> attributes) {
    this.attributes.addAll(attributes);
  }

  @Override
  public String getKey() {
    return name;
  }

  ///// USED BY CODEGEN LOGIC ///////
  public boolean isModelVisible() {
    return true;
  }

  public String getModelTemplate() {
    return "models2/message";
  }

  public String getWrappedAttributeType() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public String getBeanItemJavaType() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public String getProtoItemJavaType() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public boolean isAbstract() {
    return false;
  }

  public boolean isHasSubclasses() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public SyntheticAttribute getNestedAttribute() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public String getBeanJavaType() {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public String getProtoJavaType(MapperConfig mapperConfig) {
    throw new UnsupportedOperationException("Must be implemented by subclasses");
  }

  public boolean isPrimitiveType() {
    return false;
  }

  public boolean isRenderModel() {
    return true;
  }

  public boolean isModelVisibleTo(AbstractMessageNode attrNativeMessageType) {
    return true;
  }
}
