package com.github.krr.schema.generator.protobuf.model.nodes.messages;

import com.github.krr.schema.generator.protobuf.model.nodes.attributes.EnumAttribute;
import lombok.Getter;

@SuppressWarnings("rawtypes")
public class EnumMessageNode extends JavaBeanMessageNode {

  @Getter
  private EnumAttribute unknownProtoValue;

  public EnumMessageNode(String name, Class clazz) {
    super(name, clazz);
  }

  public void setUnknownProtoValue(EnumAttribute unknownProtoValue) {
    this.unknownProtoValue = unknownProtoValue;
  }

  @Override
  public String getModelTemplate() {
    return "models2/enumMessage";
  }

  @Override
  public String getBeanItemJavaType() {
    return name;
  }

  @Override
  public String getProtoItemJavaType() {
    return protoMessageName;
  }
}
