package com.github.krr.schema.generator.protobuf.model.nodes.messages;

import lombok.Getter;

@SuppressWarnings("rawtypes")
public class GenericMessageNode extends AbstractSyntheticMessageNode {

  @Getter
  private final boolean primitiveType;

  public GenericMessageNode(String name, Class rawType) {
    this(name, rawType, false);
  }

  public GenericMessageNode(String name, Class rawType, boolean primitiveType) {
    super(name, rawType);
    this.primitiveType = primitiveType;
  }

  @Override
  public String getKey() {
    return name;
  }

  @Override
  public String getBeanItemJavaType() {
    if(primitiveType) {
      return javaType.getTypeName();
    }
    return super.getBeanItemJavaType();
  }

  @Override
  public String getProtoItemJavaType() {
    if(primitiveType) {
      return javaType.getTypeName();
    }
    return super.getProtoItemJavaType();
  }

  // Generic messages are always rendered.
  @Override
  public boolean isRenderModel() {
    return true;
  }
}
