package com.github.krr.schema.generator.protobuf.model.nodes.messages;

import lombok.Getter;
import lombok.Setter;

import java.lang.reflect.Modifier;

@SuppressWarnings("rawtypes")
public class JavaBeanMessageNode extends AbstractMessageNode {

  @Getter
  protected Class beanJavaClass;

  @Setter
  @Getter
  protected AbstractMessageNode superclassMessage;

  @Getter
  @Setter
  protected boolean hasSubclasses;

  public JavaBeanMessageNode(String name, Class clazz) {
    super(name);
    this.beanJavaClass = clazz;
  }

  @Override
  public String getKey() {
    return beanJavaClass.getName();
  }

  @Override
  public String getBeanJavaType() {
    return beanJavaClass.getName().replaceAll("\\$", ".");
  }

  public String getSimpleBeanName() {
    String classname = beanJavaClass.getName();
    return classname.substring(classname.lastIndexOf(".") + 1).replaceAll("\\$", "Dollar");
  }

  @Override
  public boolean isAbstract() {
    return Modifier.isAbstract(beanJavaClass.getModifiers());
  }

  @Override
  public String getBeanItemJavaType() {
    return beanJavaClass.getName().replaceAll("\\$", ".");
  }

  @Override
  public String getProtoItemJavaType() {
    return protoMessageName;
  }
}
