package com.github.krr.schema.generator.protobuf.model.nodes.messages;

import org.springframework.util.Assert;

import java.lang.reflect.Type;

public class MapMessageNode extends AbstractSyntheticMessageNode {

  public MapMessageNode(Type type, String name)  {
    super(name, type);
  }

  @Override
  public String getToProtoItemMethodName() {
    Assert.isAssignable(AbstractSyntheticMessageNode.class, wrappedMessage.getClass(), "MapMessageNode expects an AbstractSyntheticMessageNode");
    if(isModelVisible()) {
      return ((AbstractSyntheticMessageNode)wrappedMessage).getToProtoItemMethodName();
    }
    return null;
  }

  @Override
  public String getFromProtoItemMethodName() {
    Assert.isAssignable(AbstractSyntheticMessageNode.class, wrappedMessage.getClass(), "MapMessageNode expects an AbstractSyntheticMessageNode");
    if(isModelVisible()) {
      return ((AbstractSyntheticMessageNode)wrappedMessage).getFromProtoItemMethodName();
    }
    return null;
  }
}
