package com.github.krr.schema.generator.protobuf.model.nodes.messages;

import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

public class OneOfSyntheticMessageDecorator extends AbstractMessageNode {

  private final AbstractMessageNode decoratedMessage;

  @Getter
  @Setter
  private long index;

  public OneOfSyntheticMessageDecorator(AbstractMessageNode decoratedMessage, long index) {
    super(decoratedMessage.getName());
    this.decoratedMessage = decoratedMessage;
    this.index = index;
  }

  @Override
  public String getName() {
    return StringUtils.uncapitalize(decoratedMessage.getName());
  }

  @Override
  public String getProtoMessageName() {
    return decoratedMessage.getProtoMessageName();
  }

  @Override
  public boolean isModelVisible() {
    return decoratedMessage.isModelVisible();
  }

  public String getProtoVar() {
    String name = decoratedMessage.getName();
    return StringUtils.uncapitalize(name.substring(name.lastIndexOf(".") + 1).replaceAll("\\$", "Dollar"));
  }
}
