package com.github.krr.schema.generator.protobuf.model.nodes.messages;

import lombok.Getter;
import lombok.Setter;

import java.lang.reflect.Type;

public class OneOfSyntheticMessageNode extends AbstractSyntheticMessageNode {

  @Getter
  @Setter
  private AbstractMessageNode realMessage;

  public OneOfSyntheticMessageNode(String name, Type originalBeanType) {
    super(name, originalBeanType);
  }

  @Override
  public boolean isCreateMessage() {
    return true;
  }

  @Override
  public String getModelTemplate() {
    return "models2/oneofWrapper";
  }

  /**
   * A model is visible if the nested nodes it holds themselves have at least one
   * nested node.  This is because when the graph is built we do not know whether
   * we will need to wrap these synthetic messages (List&lt;List&gt;, List&lt;Map&gt; etc).
   *
   * @return true if the model is visible and false otherwise.
   */
  @Override
  public boolean isModelVisible() {
    return referencedNodes.size() > 0;
  }

}
