package com.github.krr.schema.generator.protobuf.utils;

import com.github.krr.schema.generator.annotations.SchemaItem;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

import static com.github.krr.schema.generator.protobuf.model.nodes.attributes.ProtoPrimitiveAttribute.PROTO_PRIMITIVE_TYPE_MAP;

public class MapperCodegenModelUtils {

  public static final String DOLLAR = "Dollar";

  public static String getSimpleJavaBeanName(String fqName) {
    return fqName.substring(fqName.lastIndexOf(".")+1).replaceAll("\\$", DOLLAR);
  }

  public static String getBaseClassName(Class clazz) {
    SchemaItem schemaItem = AnnotationUtils.findAnnotation(clazz, SchemaItem.class);
    if (schemaItem != null && !StringUtils.isEmpty(schemaItem.alias())) {
      return schemaItem.alias();
    }
    if(isProtoNativeType(clazz)) {
      return PROTO_PRIMITIVE_TYPE_MAP.get(clazz);
    }
    // don't use getSimpleName because it won't work with inner classes
    return getProtoCompatibleJavaClassname(clazz);
  }

  public static boolean isProtoNativeType(Class clazz) {
    return PROTO_PRIMITIVE_TYPE_MAP.containsKey(clazz);
  }

  public static String getProtoCompatibleJavaClassname(Class clazz) {
    String className = clazz.getName();
    className = className.substring(className.lastIndexOf(".") + 1);
    return className.replaceAll("\\$", DOLLAR);
  }

}
