package com.github.krr.schema.generator.protobuf.utils;

import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.internal.lang3.StringUtils;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

@SuppressWarnings("unused")
@Slf4j
public class MustacheHelpers {

  public static final String SEPARATOR = ",";

  public static Object booleanBeanProperty(String val, Options options) throws IOException {
    Options.Buffer buffer = options.buffer();
    if(!val.startsWith("Is") && !val.startsWith("is")) {
      buffer.append(String.format("is%s", StringUtils.capitalize(val)));
    }
    else {
      buffer.append(StringUtils.uncapitalize(val));
    }
    return buffer;
  }

  public static Object ifEquals(String val1, String val2, Options options) throws IOException {
    Options.Buffer buffer = options.buffer();
    if(val1.equals(val2)) {
      buffer.append(options.fn());
    }
    else {
      buffer.append(options.inverse());
    }
    return buffer;
  }

  @SuppressWarnings("unchecked")
  public static Object convertDelimitedStringToIterable(String commaSeparatedList, String separator, String itemKey, Options options) {
    Options.Buffer buffer = options.buffer();
    if (separator == null) {
      separator = SEPARATOR;
    }
    if(itemKey == null) {
      itemKey = "items";
    }
    String[] items = commaSeparatedList.split(separator);
    ((Map<String, Object>)options.context.model()).put(itemKey, Arrays.asList(items));
    return buffer;
  }

  public static Object mavenCoordinates(String mavenCoordinates, String part, Options options) throws IOException {
    Options.Buffer buffer = options.buffer();
    String[] mavenCoords = StringUtils.trim(mavenCoordinates).split(":");
    if ("groupId".equals(part)) {
      buffer.append(mavenCoords[0]);
    }
    else if ("artifactId".equals(part)) {
      buffer.append(mavenCoords[1]);
    }
    else if ("version".equals(part)) {
      buffer.append(mavenCoords[2]);
    }
    else {
      log.debug("Invalid or unknown key {} for maven coordinates.  Valid values are groupId, artifactId, version ", part);
      throw new IllegalArgumentException("Invalid or unknown key for maven coordinates:" + part + ".  Valid values are groupId, artifactId, version");
    }
    return buffer;
  }

  public static Object capitalize(String varName, Options options) throws IOException {
    Options.Buffer buffer = options.buffer();
    String capitalizedVarName = StringUtils.capitalize(varName);
    log.debug("Input {} capitalized as {}", varName, capitalizedVarName);
    return capitalizedVarName;
  }

  public static Object uncapitalize(String varName, Options options) {
    Options.Buffer buffer = options.buffer();
    String uncapitalizedVarName = StringUtils.uncapitalize(varName);
    log.debug("Input {} uncapitalized as {}", varName, uncapitalizedVarName);
    return uncapitalizedVarName;
  }

  public static Object upperCase(String varName, Options options) {
    Options.Buffer buffer = options.buffer();
    String uppercaseVarName = varName.toUpperCase();
    log.debug("Input {} in uppercase is {}", varName, uppercaseVarName);
    return uppercaseVarName;
  }

  public static Object jsenumify(String varName, Options options) {
    Options.Buffer buffer = options.buffer();
    String uppercaseVarName = varName.toUpperCase();
    log.debug("Input {} as enum is {}", varName, uppercaseVarName);
    return uppercaseVarName.replaceAll("\\$", "_");
  }

  public static Object concat(String var1, Object var2, Options options) throws IOException {
    Options.Buffer buffer = options.buffer();
    String concatenatedValue = var1.concat(var2.toString());
    log.error("New value={}", concatenatedValue);
    return concatenatedValue;
  }

}
