/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram;

import com.github.kshashov.telegram.MethodProcessorsConfiguration;
import com.github.kshashov.telegram.TelegramConfigurationProperties;
import com.github.kshashov.telegram.TelegramControllerBeanPostProcessor;
import com.github.kshashov.telegram.TelegramScope;
import com.github.kshashov.telegram.TelegramSessionResolver;
import com.github.kshashov.telegram.api.TelegramMvcController;
import com.github.kshashov.telegram.api.TelegramSession;
import com.github.kshashov.telegram.config.TelegramBotGlobalProperties;
import com.github.kshashov.telegram.config.TelegramBotGlobalPropertiesConfiguration;
import com.github.kshashov.telegram.config.TelegramBotProperties;
import com.github.kshashov.telegram.handler.DefaultRequestMappingsMatcherStrategy;
import com.github.kshashov.telegram.handler.DefaultTelegramUpdatesHandler;
import com.github.kshashov.telegram.handler.HandlerMethodContainer;
import com.github.kshashov.telegram.handler.RequestMappingsMatcherStrategy;
import com.github.kshashov.telegram.handler.TelegramPollingService;
import com.github.kshashov.telegram.handler.TelegramService;
import com.github.kshashov.telegram.handler.TelegramUpdatesHandler;
import com.github.kshashov.telegram.handler.TelegramWebhookService;
import com.github.kshashov.telegram.handler.processor.RequestDispatcher;
import com.github.kshashov.telegram.handler.processor.arguments.BotHandlerMethodArgumentResolver;
import com.github.kshashov.telegram.handler.processor.arguments.BotHandlerMethodArgumentResolverComposite;
import com.github.kshashov.telegram.handler.processor.response.BotHandlerMethodReturnValueHandler;
import com.github.kshashov.telegram.handler.processor.response.BotHandlerMethodReturnValueHandlerComposite;
import com.github.kshashov.telegram.metrics.MetricsConfiguration;
import com.github.kshashov.telegram.metrics.MetricsService;
import com.pengrad.telegrambot.Callback;
import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.response.BaseResponse;
import io.javalin.Javalin;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={MethodProcessorsConfiguration.class, MetricsConfiguration.class})
@EnableConfigurationProperties(value={TelegramConfigurationProperties.class})
public class TelegramAutoConfiguration
implements BeanFactoryPostProcessor,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(TelegramAutoConfiguration.class);
    private Environment environment;

    @Bean
    Javalin javalinServer(@Qualifier(value="telegramBotPropertiesList") List<TelegramBotProperties> botProperties, TelegramBotGlobalProperties globalProperties) {
        boolean hasWebhook = botProperties.stream().anyMatch(p -> p.getWebhook() != null);
        if (!hasWebhook) {
            return null;
        }
        try {
            Javalin server = Javalin.create().start(globalProperties.getWebserverPort().intValue());
            log.info("Javalin server has been started on {} port", (Object)globalProperties.getWebserverPort());
            return server;
        }
        catch (Exception ex) {
            log.error("An unexpected error occured while starting Javalin server", (Throwable)ex);
            return null;
        }
    }

    @Bean
    TelegramUpdatesHandler telegramUpdatesHandler(TelegramBotGlobalProperties globalProperties, RequestDispatcher requestDispatcher, MetricsService metricsService) {
        return new DefaultTelegramUpdatesHandler(requestDispatcher, globalProperties, metricsService);
    }

    @Bean
    @Qualifier(value="telegramServicesList")
    List<TelegramService> telegramServices(@Qualifier(value="telegramBotPropertiesList") List<TelegramBotProperties> botProperties, TelegramUpdatesHandler updatesHandler, TelegramBotGlobalProperties globalProperties, Optional<Javalin> server) {
        List<TelegramService> services = botProperties.stream().map(p -> {
            TelegramBot bot = p.getBotBuilder().build();
            if (globalProperties.getBotProcessors().containsKey(p.getToken())) {
                globalProperties.getBotProcessors().get(p.getToken()).accept(bot);
            }
            if (p.getWebhook() != null) {
                return new TelegramWebhookService((TelegramBotProperties)p, bot, updatesHandler, (Javalin)server.get());
            }
            return new TelegramPollingService((TelegramBotProperties)p, bot, updatesHandler);
        }).collect(Collectors.toList());
        if (services.isEmpty()) {
            log.error("No bot configurations found");
        } else {
            log.info("Finished Telegram controllers scanning. Found {} bots", (Object)services.size());
        }
        return services;
    }

    @Bean
    @Qualifier(value="telegramBotPropertiesList")
    List<TelegramBotProperties> telegramBotPropertiesList(List<TelegramMvcController> controllers, TelegramBotGlobalProperties globalProperties) {
        return controllers.stream().map(TelegramMvcController::getToken).distinct().map(token -> {
            TelegramBotProperties.Builder defaultBuilder = this.createDefaultBotPropertiesBuilder((String)token, globalProperties);
            if (globalProperties.getBotProperties().containsKey(token)) {
                globalProperties.getBotProperties().get(token).accept(defaultBuilder);
            }
            return defaultBuilder.build();
        }).collect(Collectors.toList());
    }

    @Bean
    RequestDispatcher requestDispatcher(HandlerMethodContainer handlerMethodContainer, TelegramSessionResolver sessionResolver, TelegramBotGlobalProperties botGlobalProperties, MetricsService metricsService) {
        BotHandlerMethodArgumentResolverComposite argumentResolver = new BotHandlerMethodArgumentResolverComposite(botGlobalProperties.getArgumentResolvers());
        BotHandlerMethodReturnValueHandlerComposite returnValueHandler = new BotHandlerMethodReturnValueHandlerComposite(botGlobalProperties.getReturnValueHandlers());
        return new RequestDispatcher(handlerMethodContainer, sessionResolver, argumentResolver, returnValueHandler, metricsService);
    }

    @Bean
    TelegramBotGlobalProperties telegramBotGlobalProperties(TelegramBotGlobalPropertiesConfiguration botGlobalPropertiesConfiguration, RequestMappingsMatcherStrategy matcherStrategy, List<BotHandlerMethodArgumentResolver> argumentResolvers, List<BotHandlerMethodReturnValueHandler> returnValueHandlers, TelegramConfigurationProperties properties) {
        TelegramBotGlobalProperties.Builder defaultBuilder = this.createDefaultBotGlobalPropertiesBuilder(matcherStrategy, argumentResolvers, returnValueHandlers, properties);
        botGlobalPropertiesConfiguration.configure(defaultBuilder);
        return defaultBuilder.build();
    }

    @Bean
    TelegramSessionResolver telegramSessionResolver(ApplicationContext context) {
        return new TelegramSessionResolver(context);
    }

    @Bean
    @ConditionalOnMissingBean(value={TelegramBotGlobalPropertiesConfiguration.class})
    TelegramBotGlobalPropertiesConfiguration telegramBotGlobalPropertiesConfiguration() {
        return builder -> {};
    }

    @Bean
    @ConditionalOnMissingBean(value={RequestMappingsMatcherStrategy.class})
    RequestMappingsMatcherStrategy defaultHandLerMethodsComparator() {
        return new DefaultRequestMappingsMatcherStrategy();
    }

    @Bean
    @org.springframework.context.annotation.Scope(value="telegramScope", proxyMode=ScopedProxyMode.TARGET_CLASS)
    TelegramSession telegramSession() {
        return new TelegramSession();
    }

    @Bean
    HandlerMethodContainer handlerMethodContainer() {
        return new HandlerMethodContainer();
    }

    @Bean
    TelegramControllerBeanPostProcessor telegramControllerBeanPostProcessor(HandlerMethodContainer handlerMethodContainer, MetricsService metricsService) {
        return new TelegramControllerBeanPostProcessor(handlerMethodContainer, metricsService);
    }

    @Bean
    ApplicationListener<ContextRefreshedEvent> onContextRefreshed(@Qualifier(value="telegramServicesList") List<TelegramService> telegramServices, TelegramBotGlobalProperties globalProperties, HandlerMethodContainer handlerMethodContainer) {
        handlerMethodContainer.setMatcherStrategy(globalProperties.getMatcherStrategy());
        return event -> telegramServices.forEach(s -> globalProperties.getTaskExecutor().execute(s::start));
    }

    @Bean
    ApplicationListener<ContextClosedEvent> onContextClosed(TelegramBotGlobalProperties globalProperties, @Qualifier(value="telegramServicesList") List<TelegramService> telegramServices) {
        return event -> {
            telegramServices.forEach(TelegramService::stop);
            if (globalProperties.getTaskExecutor() != null) {
                log.info("Shutting down ThreadPoolExecutor");
                globalProperties.getTaskExecutor().shutdown();
                log.info("ThreadPoolExecutor has been shut down");
            }
        };
    }

    private TelegramBotGlobalProperties.Builder createDefaultBotGlobalPropertiesBuilder(@NotNull RequestMappingsMatcherStrategy matcherStrategy, @NotNull List<BotHandlerMethodArgumentResolver> argumentResolvers, @NotNull List<BotHandlerMethodReturnValueHandler> returnValueHandlers, @NotNull TelegramConfigurationProperties properties) {
        return TelegramBotGlobalProperties.builder().matcherStrategy(matcherStrategy).argumentResolvers(argumentResolvers).returnValueHandlers(returnValueHandlers).setWebserverPort(properties.getServerPort()).taskExecutor(new ThreadPoolExecutor(properties.getCorePoolSize(), properties.getMaxPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>())).responseCallback(new Callback(){

            public void onResponse(BaseRequest request, BaseResponse response) {
            }

            public void onFailure(BaseRequest request, IOException e) {
            }
        });
    }

    private TelegramBotProperties.Builder createDefaultBotPropertiesBuilder(@NotNull String token, @NotNull TelegramBotGlobalProperties globalProperties) {
        return TelegramBotProperties.builder(token).configure(builder -> builder.apiUrl("https://api.telegram.org/bot").updateListenerSleep(((Long)this.environment.getProperty("telegram.bot.update-listener-sleep", Long.class, (Object)300L)).longValue()).okHttpClient(new OkHttpClient.Builder().dispatcher(new Dispatcher((ExecutorService)globalProperties.getTaskExecutor())).build()));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerScope("telegramScope", (Scope)new TelegramScope(beanFactory, ((Integer)this.environment.getProperty("telegram.bot.session-seconds", Integer.class, (Object)3600)).intValue()));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

