/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram;

import com.github.kshashov.telegram.api.TelegramMvcController;
import com.github.kshashov.telegram.api.bind.annotation.BotController;
import com.github.kshashov.telegram.api.bind.annotation.BotRequest;
import com.github.kshashov.telegram.handler.HandlerMethodContainer;
import com.github.kshashov.telegram.handler.RequestMappingInfo;
import com.github.kshashov.telegram.handler.processor.HandlerMethod;
import com.github.kshashov.telegram.metrics.MetricsService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class TelegramControllerBeanPostProcessor
implements BeanPostProcessor,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(TelegramControllerBeanPostProcessor.class);
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final HandlerMethodContainer botHandlerMethodContainer;
    private final MetricsService metricsService;

    public TelegramControllerBeanPostProcessor(@NotNull HandlerMethodContainer botHandlerMethodContainer, @NotNull MetricsService metricsService) {
        this.botHandlerMethodContainer = botHandlerMethodContainer;
        this.metricsService = metricsService;
    }

    public Object postProcessBeforeInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        return bean;
    }

    @Nullable
    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (!this.nonAnnotatedClasses.contains(targetClass)) {
            if (TelegramMvcController.class.isAssignableFrom(targetClass) && AnnotationUtils.findAnnotation((Class)targetClass, BotController.class) != null) {
                TelegramMvcController controller = (TelegramMvcController)bean;
                Map<Method, List<RequestMappingInfo>> annotatedMethods = this.findAnnotatedMethodsBotRequest(controller.getToken(), targetClass);
                if (annotatedMethods.isEmpty()) {
                    this.nonAnnotatedClasses.add(targetClass);
                    if (log.isTraceEnabled()) {
                        log.warn("No @BotRequest annotations found on bean class: {}", bean.getClass());
                    }
                } else {
                    annotatedMethods.forEach((method, mappingInfos) -> {
                        Method invocableMethod = AopUtils.selectInvocableMethod((Method)method, (Class)targetClass);
                        HandlerMethod handlerMethod = this.botHandlerMethodContainer.registerController(bean, invocableMethod, (List<RequestMappingInfo>)mappingInfos);
                        this.metricsService.registerHandlerMethod(handlerMethod);
                    });
                }
            } else {
                this.nonAnnotatedClasses.add(targetClass);
            }
        }
        return bean;
    }

    private Map<Method, List<RequestMappingInfo>> findAnnotatedMethodsBotRequest(String token, Class<?> targetClass) {
        return MethodIntrospector.selectMethods(targetClass, method -> {
            BotRequest requestMapping = (BotRequest)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, BotRequest.class);
            if (requestMapping == null) {
                return null;
            }
            HashSet types = Sets.newHashSet((Object[])requestMapping.type());
            if (requestMapping.path().length == 0) {
                return Lists.newArrayList((Object[])new RequestMappingInfo[]{new RequestMappingInfo(token, null, Integer.MAX_VALUE, types)});
            }
            return Arrays.stream(requestMapping.path()).map(path -> new RequestMappingInfo(token, (String)path, requestMapping.path().length, types)).collect(Collectors.toList());
        });
    }

    public void afterSingletonsInstantiated() {
        this.nonAnnotatedClasses.clear();
    }
}

