/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram;

import com.github.kshashov.telegram.TelegramScopeException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.lang.NonNull;

public class TelegramScope
implements Scope {
    private static final Logger log = LoggerFactory.getLogger(TelegramScope.class);
    public static final String SCOPE = "telegramScope";
    private static final ThreadLocal<Long> USER_THREAD_LOCAL = new ThreadLocal();
    private final ConfigurableListableBeanFactory beanFactory;
    private final LoadingCache<String, ConcurrentHashMap<String, Object>> conversations;

    TelegramScope(@NotNull ConfigurableListableBeanFactory beanFactory, long expireSeconds) {
        this.beanFactory = beanFactory;
        this.conversations = CacheBuilder.newBuilder().expireAfterAccess(expireSeconds, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.wasEvicted()) {
                log.debug("Evict session for key {}", notification.getKey());
                Map userScope = (Map)notification.getValue();
                if (userScope != null) {
                    userScope.values().forEach(this::removeBean);
                }
            }
        }).build((CacheLoader)new CacheLoader<String, ConcurrentHashMap<String, Object>>(){

            public ConcurrentHashMap<String, Object> load(@NonNull String key) {
                log.debug("Create session for key = {}", (Object)key);
                return new ConcurrentHashMap<String, Object>();
            }
        });
    }

    static void setIdThreadLocal(Long chatId) {
        USER_THREAD_LOCAL.set(chatId);
    }

    static void removeId() {
        USER_THREAD_LOCAL.remove();
    }

    private void removeBean(Object bean) {
        this.beanFactory.destroyBean(bean);
    }

    @NonNull
    public Object get(@NonNull String name, @NonNull ObjectFactory<?> objectFactory) throws TelegramScopeException {
        ConcurrentHashMap beans;
        String sessionId = this.getConversationId();
        if (sessionId == null) {
            throw new TelegramScopeException("There is no current session");
        }
        try {
            beans = (ConcurrentHashMap)this.conversations.get((Object)sessionId);
        }
        catch (ExecutionException e) {
            throw new TelegramScopeException(e);
        }
        return beans.computeIfAbsent(name, k -> objectFactory.getObject());
    }

    public Object remove(@NonNull String name) {
        Map userBeans;
        String sessionId = this.getConversationId();
        if (sessionId != null && (userBeans = (Map)this.conversations.getIfPresent((Object)sessionId)) != null) {
            return userBeans.remove(name);
        }
        return null;
    }

    public void registerDestructionCallback(@NonNull String name, @NonNull Runnable callback) {
    }

    public Object resolveContextualObject(@NonNull String key) {
        return null;
    }

    public String getConversationId() {
        Long id = USER_THREAD_LOCAL.get();
        if (id == null) {
            return null;
        }
        return Long.toString(id);
    }
}

