/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram;

import com.github.kshashov.telegram.TelegramScope;
import com.github.kshashov.telegram.api.TelegramSession;
import com.github.kshashov.telegram.handler.processor.TelegramEvent;
import javax.validation.constraints.NotNull;
import org.springframework.context.ApplicationContext;

public class TelegramSessionResolver {
    private ApplicationContext context;

    public TelegramSessionResolver(ApplicationContext context) {
        this.context = context;
    }

    @NotNull
    public TelegramSessionHolder resolveTelegramSession(@NotNull TelegramEvent telegramEvent) {
        TelegramScope.setIdThreadLocal(this.getSessionIdForRequest(telegramEvent));
        return new TelegramSessionHolder((TelegramSession)this.context.getBean(TelegramSession.class));
    }

    private Long getSessionIdForRequest(@NotNull TelegramEvent telegramEvent) {
        if (telegramEvent.getChat() != null) {
            return telegramEvent.getChat().id();
        }
        if (telegramEvent.getUser() != null) {
            return (long)telegramEvent.getUser().id();
        }
        return (long)telegramEvent.getUpdate().updateId();
    }

    public static class TelegramSessionHolder {
        @NotNull
        private final TelegramSession session;

        public void releaseSessionId() {
            TelegramScope.removeId();
        }

        @NotNull
        public TelegramSession getSession() {
            return this.session;
        }

        public TelegramSessionHolder(@NotNull TelegramSession session) {
            this.session = session;
        }
    }
}

