/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.config;

import com.github.kshashov.telegram.config.TelegramBotProperties;
import com.github.kshashov.telegram.handler.RequestMappingsMatcherStrategy;
import com.github.kshashov.telegram.handler.processor.arguments.BotHandlerMethodArgumentResolver;
import com.github.kshashov.telegram.handler.processor.response.BotHandlerMethodReturnValueHandler;
import com.pengrad.telegrambot.Callback;
import com.pengrad.telegrambot.TelegramBot;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import javax.validation.constraints.NotNull;

public class TelegramBotGlobalProperties {
    @NotNull
    private final Integer webserverPort;
    @NotNull
    private final ThreadPoolExecutor taskExecutor;
    @NotNull
    private final RequestMappingsMatcherStrategy matcherStrategy;
    @NotNull
    private final Callback responseCallback;
    @NotNull
    private final List<BotHandlerMethodArgumentResolver> argumentResolvers;
    @NotNull
    private final List<BotHandlerMethodReturnValueHandler> returnValueHandlers;
    @NotNull
    private final Map<String, Consumer<TelegramBotProperties.Builder>> botProperties;
    @NotNull
    private final Map<String, Consumer<TelegramBot>> botProcessors;

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public Integer getWebserverPort() {
        return this.webserverPort;
    }

    @NotNull
    public ThreadPoolExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    @NotNull
    public RequestMappingsMatcherStrategy getMatcherStrategy() {
        return this.matcherStrategy;
    }

    @NotNull
    public Callback getResponseCallback() {
        return this.responseCallback;
    }

    @NotNull
    public List<BotHandlerMethodArgumentResolver> getArgumentResolvers() {
        return this.argumentResolvers;
    }

    @NotNull
    public List<BotHandlerMethodReturnValueHandler> getReturnValueHandlers() {
        return this.returnValueHandlers;
    }

    @NotNull
    public Map<String, Consumer<TelegramBotProperties.Builder>> getBotProperties() {
        return this.botProperties;
    }

    @NotNull
    public Map<String, Consumer<TelegramBot>> getBotProcessors() {
        return this.botProcessors;
    }

    public TelegramBotGlobalProperties(@NotNull Integer webserverPort, @NotNull ThreadPoolExecutor taskExecutor, @NotNull RequestMappingsMatcherStrategy matcherStrategy, @NotNull Callback responseCallback, @NotNull List<BotHandlerMethodArgumentResolver> argumentResolvers, @NotNull List<BotHandlerMethodReturnValueHandler> returnValueHandlers, @NotNull Map<String, Consumer<TelegramBotProperties.Builder>> botProperties, @NotNull Map<String, Consumer<TelegramBot>> botProcessors) {
        this.webserverPort = webserverPort;
        this.taskExecutor = taskExecutor;
        this.matcherStrategy = matcherStrategy;
        this.responseCallback = responseCallback;
        this.argumentResolvers = argumentResolvers;
        this.returnValueHandlers = returnValueHandlers;
        this.botProperties = botProperties;
        this.botProcessors = botProcessors;
    }

    public static class Builder {
        private final Map<String, Consumer<TelegramBotProperties.Builder>> botProperties = new HashMap<String, Consumer<TelegramBotProperties.Builder>>();
        private final Map<String, Consumer<TelegramBot>> botProcessors = new HashMap<String, Consumer<TelegramBot>>();
        private ThreadPoolExecutor taskExecutor;
        private RequestMappingsMatcherStrategy matcherStrategy;
        private Callback responseCallback;
        private List<BotHandlerMethodArgumentResolver> argumentResolvers;
        private List<BotHandlerMethodReturnValueHandler> returnValueHandlers;
        private int webserverPort;

        public Builder taskExecutor(@NotNull ThreadPoolExecutor taskExecutor) {
            this.taskExecutor = taskExecutor;
            return this;
        }

        public Builder matcherStrategy(RequestMappingsMatcherStrategy matcherStrategy) {
            this.matcherStrategy = matcherStrategy;
            return this;
        }

        public Builder responseCallback(@NotNull Callback responseCallback) {
            this.responseCallback = responseCallback;
            return this;
        }

        public Builder argumentResolvers(@NotNull List<BotHandlerMethodArgumentResolver> argumentResolvers) {
            this.argumentResolvers = argumentResolvers;
            return this;
        }

        public Builder returnValueHandlers(@NotNull List<BotHandlerMethodReturnValueHandler> returnValueHandlers) {
            this.returnValueHandlers = returnValueHandlers;
            return this;
        }

        public Builder configureBot(@NotNull String token, @NotNull Consumer<TelegramBotProperties.Builder> propertiesConsumer) {
            this.botProperties.put(token, propertiesConsumer);
            return this;
        }

        public Builder processBot(@NotNull String token, @NotNull Consumer<TelegramBot> botConsumer) {
            this.botProcessors.put(token, botConsumer);
            return this;
        }

        public Builder setWebserverPort(int webserverPort) {
            this.webserverPort = webserverPort;
            return this;
        }

        public TelegramBotGlobalProperties build() {
            return new TelegramBotGlobalProperties(this.webserverPort, this.taskExecutor, this.matcherStrategy, this.responseCallback, this.argumentResolvers, this.returnValueHandlers, this.botProperties, this.botProcessors);
        }
    }
}

