/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.config;

import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.request.SetWebhook;
import java.util.function.Consumer;
import javax.validation.constraints.NotNull;

public class TelegramBotProperties {
    @NotNull
    private final String token;
    @NotNull
    private final TelegramBot.Builder botBuilder;
    private final SetWebhook webhook;
    private final boolean keepWebhookRegistration;

    public static Builder builder(String token) {
        return new Builder(token);
    }

    @NotNull
    public String getToken() {
        return this.token;
    }

    @NotNull
    public TelegramBot.Builder getBotBuilder() {
        return this.botBuilder;
    }

    public SetWebhook getWebhook() {
        return this.webhook;
    }

    public boolean isKeepWebhookRegistration() {
        return this.keepWebhookRegistration;
    }

    public TelegramBotProperties(@NotNull String token, @NotNull TelegramBot.Builder botBuilder, SetWebhook webhook, boolean keepWebhookRegistration) {
        this.token = token;
        this.botBuilder = botBuilder;
        this.webhook = webhook;
        this.keepWebhookRegistration = keepWebhookRegistration;
    }

    public static class Builder {
        private final TelegramBot.Builder botBuilder;
        private final String token;
        private SetWebhook webhook;
        private boolean keepWebhookRegistration;

        Builder(@NotNull String token) {
            this.token = token;
            this.botBuilder = new TelegramBot.Builder(token);
        }

        public Builder configure(Consumer<TelegramBot.Builder> builderConsumer) {
            builderConsumer.accept(this.botBuilder);
            return this;
        }

        public Builder useWebhook(@NotNull SetWebhook webhook) {
            return this.useWebhook(webhook, false);
        }

        public Builder useWebhook(@NotNull SetWebhook webhook, boolean keepWebhookRegistration) {
            this.webhook = webhook;
            this.keepWebhookRegistration = keepWebhookRegistration;
            return this;
        }

        public TelegramBotProperties build() {
            return new TelegramBotProperties(this.token, this.botBuilder, this.webhook, this.keepWebhookRegistration);
        }
    }
}

