/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler;

import com.github.kshashov.telegram.api.MessageType;
import com.github.kshashov.telegram.handler.HandlerMethodContainer;
import com.github.kshashov.telegram.handler.RequestMappingInfo;
import com.github.kshashov.telegram.handler.RequestMappingsMatcherStrategy;
import com.github.kshashov.telegram.handler.processor.TelegramEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class DefaultRequestMappingsMatcherStrategy
implements RequestMappingsMatcherStrategy,
Comparator<RequestMappingInfo> {
    private final PathMatcher pathMatcher;

    public DefaultRequestMappingsMatcherStrategy() {
        this((PathMatcher)new AntPathMatcher());
    }

    public DefaultRequestMappingsMatcherStrategy(@NotNull PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    @Override
    public boolean isMatched(@NotNull TelegramEvent telegramEvent, @NotNull RequestMappingInfo mappingInfo) {
        if (!mappingInfo.getMessageTypes().contains((Object)telegramEvent.getMessageType()) && !mappingInfo.getMessageTypes().contains((Object)MessageType.ANY)) {
            return false;
        }
        String text = telegramEvent.getText();
        if (text == null) {
            text = "";
        }
        return this.pathMatcher.match(mappingInfo.getPattern(), text);
    }

    @Override
    @NotNull
    public List<HandlerMethodContainer.RequestMapping> postProcess(@NotNull List<HandlerMethodContainer.RequestMapping> mappings) {
        ArrayList<HandlerMethodContainer.RequestMapping> result = new ArrayList<HandlerMethodContainer.RequestMapping>(mappings);
        result.forEach(mapping -> {
            if (mapping.getMappingInfo().getPattern() == null) {
                RequestMappingInfo info = mapping.getMappingInfo();
                mapping.setMappingInfo(new RequestMappingInfo(info.getToken(), "**", info.getPatternsCount(), info.getMessageTypes()));
            }
        });
        result.sort((o1, o2) -> this.compare(o1.getMappingInfo(), o2.getMappingInfo()));
        return result;
    }

    @Override
    @NotNull
    public Map<String, String> extractPatternVariables(@NotNull String text, @NotNull RequestMappingInfo mappingInfo) {
        if (text == null) {
            text = "";
        }
        return this.pathMatcher.extractUriTemplateVariables(mappingInfo.getPattern(), text);
    }

    @Override
    public int compare(@NotNull RequestMappingInfo o1, @NotNull RequestMappingInfo o2) {
        int compared = this.pathMatcher.getPatternComparator("").compare(o1.getPattern(), o2.getPattern());
        if (compared != 0) {
            return compared;
        }
        if (o1.getPatternsCount() != o2.getPatternsCount()) {
            return Integer.compare(o1.getPatternsCount(), o2.getPatternsCount());
        }
        Set<MessageType> t1 = o1.getMessageTypes();
        Set<MessageType> t2 = o2.getMessageTypes();
        if (t1.contains((Object)MessageType.ANY) && t2.contains((Object)MessageType.ANY)) {
            return 0;
        }
        if (t1.contains((Object)MessageType.ANY)) {
            return 1;
        }
        if (t2.contains((Object)MessageType.ANY)) {
            return -1;
        }
        if (t1.size() != t2.size()) {
            return Integer.compare(t1.size(), t2.size());
        }
        return 0;
    }
}

