/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler;

import com.github.kshashov.telegram.config.TelegramBotGlobalProperties;
import com.github.kshashov.telegram.handler.TelegramUpdatesHandler;
import com.github.kshashov.telegram.handler.processor.RequestDispatcher;
import com.github.kshashov.telegram.handler.processor.TelegramCallback;
import com.github.kshashov.telegram.handler.processor.TelegramEvent;
import com.github.kshashov.telegram.metrics.MetricsService;
import com.pengrad.telegrambot.Callback;
import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.model.Update;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.response.BaseResponse;
import java.io.IOException;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTelegramUpdatesHandler
implements TelegramUpdatesHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultTelegramUpdatesHandler.class);
    private final RequestDispatcher botRequestDispatcher;
    private final TelegramBotGlobalProperties globalProperties;
    private final MetricsService metricsService;

    public DefaultTelegramUpdatesHandler(@NotNull RequestDispatcher botRequestDispatcher, @NotNull TelegramBotGlobalProperties globalProperties, @NotNull MetricsService metricsService) {
        this.botRequestDispatcher = botRequestDispatcher;
        this.globalProperties = globalProperties;
        this.metricsService = metricsService;
    }

    @Override
    public void processUpdates(@NotNull String token, @NotNull TelegramBot bot, @NotNull List<Update> updates) {
        this.metricsService.onUpdatesReceived(updates.size());
        try {
            for (Update update : updates) {
                this.globalProperties.getTaskExecutor().execute(() -> {
                    try {
                        TelegramEvent event = new TelegramEvent(token, update, bot);
                        TelegramCallback executionResult = this.botRequestDispatcher.execute(event);
                        if (executionResult != null && executionResult.getRequest() != null) {
                            log.debug("Controller returned Telegram request {}", (Object)executionResult);
                            this.postExecute(executionResult, bot);
                        }
                    }
                    catch (IllegalStateException e) {
                        this.metricsService.onUpdateError();
                        log.error("Execution error", (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("An unhandled exception occurred while processing the Telegram request", (Throwable)e);
        }
    }

    private void postExecute(final TelegramCallback baseRequest, @NotNull TelegramBot telegramBot) {
        telegramBot.execute(baseRequest.getRequest(), new Callback(){

            public void onResponse(BaseRequest request, BaseResponse response) {
                baseRequest.onResponse(request, response);
                DefaultTelegramUpdatesHandler.this.globalProperties.getResponseCallback().onResponse(request, response);
                log.debug("{} request was successfully executed", (Object)baseRequest);
            }

            public void onFailure(BaseRequest request, IOException e) {
                baseRequest.onFailure(request, e);
                DefaultTelegramUpdatesHandler.this.globalProperties.getResponseCallback().onFailure(request, e);
                DefaultTelegramUpdatesHandler.this.metricsService.onUpdateError();
                log.error(baseRequest + " request was failed", (Throwable)e);
            }
        });
    }
}

