/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler;

import com.github.kshashov.telegram.handler.RequestMappingInfo;
import com.github.kshashov.telegram.handler.RequestMappingsMatcherStrategy;
import com.github.kshashov.telegram.handler.processor.HandlerMethod;
import com.github.kshashov.telegram.handler.processor.TelegramEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class HandlerMethodContainer {
    private final Map<String, List<RequestMapping>> handlers = new HashMap<String, List<RequestMapping>>();
    private RequestMappingsMatcherStrategy matcherStrategy;

    @NotNull
    public HandlerLookupResult lookupHandlerMethod(@NotNull TelegramEvent telegramEvent) {
        if (this.matcherStrategy == null) {
            throw new IllegalStateException("MatcherStrategy is not set");
        }
        List<RequestMapping> botMethods = this.handlers.get(telegramEvent.getToken());
        if (botMethods != null) {
            for (RequestMapping botMappings : botMethods) {
                RequestMappingInfo info = botMappings.getMappingInfo();
                if (!info.getToken().equals(telegramEvent.getToken()) || !this.matcherStrategy.isMatched(telegramEvent, info)) continue;
                Map<String, String> variables = this.matcherStrategy.extractPatternVariables(telegramEvent.getText(), info);
                return new HandlerLookupResult(botMappings.getHandlerMethod(), info.getPattern(), variables);
            }
        }
        return new HandlerLookupResult();
    }

    public HandlerMethod registerController(@NotNull Object bean, @NotNull Method method, @NotNull List<RequestMappingInfo> mappingInfo) {
        if (mappingInfo.isEmpty()) {
            return null;
        }
        HandlerMethod handlerMethod = new HandlerMethod(bean, method);
        List botHandlers = this.handlers.computeIfAbsent(mappingInfo.get(0).getToken(), k -> new ArrayList());
        mappingInfo.forEach(info -> botHandlers.add(new RequestMapping((RequestMappingInfo)info, handlerMethod)));
        return handlerMethod;
    }

    public void setMatcherStrategy(@NotNull RequestMappingsMatcherStrategy matcherStrategy) {
        this.matcherStrategy = matcherStrategy;
        this.handlers.replaceAll((key, value) -> matcherStrategy.postProcess((List<RequestMapping>)value));
    }

    public static class RequestMapping {
        private RequestMappingInfo mappingInfo;
        private HandlerMethod handlerMethod;

        public RequestMappingInfo getMappingInfo() {
            return this.mappingInfo;
        }

        public HandlerMethod getHandlerMethod() {
            return this.handlerMethod;
        }

        public void setMappingInfo(RequestMappingInfo mappingInfo) {
            this.mappingInfo = mappingInfo;
        }

        public void setHandlerMethod(HandlerMethod handlerMethod) {
            this.handlerMethod = handlerMethod;
        }

        public RequestMapping(RequestMappingInfo mappingInfo, HandlerMethod handlerMethod) {
            this.mappingInfo = mappingInfo;
            this.handlerMethod = handlerMethod;
        }
    }

    public static class HandlerLookupResult {
        @Nullable
        private HandlerMethod handlerMethod;
        @Nullable
        private String basePattern;
        @Nullable
        private Map<String, String> templateVariables;

        @Nullable
        public HandlerMethod getHandlerMethod() {
            return this.handlerMethod;
        }

        @Nullable
        public String getBasePattern() {
            return this.basePattern;
        }

        @Nullable
        public Map<String, String> getTemplateVariables() {
            return this.templateVariables;
        }

        public HandlerLookupResult() {
        }

        public HandlerLookupResult(@Nullable HandlerMethod handlerMethod, @Nullable String basePattern, @Nullable Map<String, String> templateVariables) {
            this.handlerMethod = handlerMethod;
            this.basePattern = basePattern;
            this.templateVariables = templateVariables;
        }
    }
}

