/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler;

import com.github.kshashov.telegram.config.TelegramBotProperties;
import com.github.kshashov.telegram.handler.TelegramService;
import com.github.kshashov.telegram.handler.TelegramUpdatesHandler;
import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.request.DeleteWebhook;
import com.pengrad.telegrambot.request.GetUpdates;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelegramPollingService
implements TelegramService {
    private static final Logger log = LoggerFactory.getLogger(TelegramPollingService.class);
    private final TelegramBot telegramBot;
    private final TelegramBotProperties botProperties;
    private final TelegramUpdatesHandler updatesHandler;

    public TelegramPollingService(@NotNull TelegramBotProperties botProperties, TelegramBot bot, @NotNull TelegramUpdatesHandler updatesHandler) {
        this.botProperties = botProperties;
        this.updatesHandler = updatesHandler;
        this.telegramBot = bot;
    }

    @Override
    public void start() {
        this.telegramBot.execute((BaseRequest)new DeleteWebhook());
        this.telegramBot.setUpdatesListener(updates -> {
            this.updatesHandler.processUpdates(this.botProperties.getToken(), this.telegramBot, updates);
            return -1;
        }, new GetUpdates());
    }

    @Override
    public void stop() {
        this.telegramBot.removeGetUpdatesListener();
    }
}

