/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler;

import com.github.kshashov.telegram.config.TelegramBotProperties;
import com.github.kshashov.telegram.handler.TelegramService;
import com.github.kshashov.telegram.handler.TelegramUpdatesHandler;
import com.pengrad.telegrambot.BotUtils;
import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.model.Update;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.request.DeleteWebhook;
import com.pengrad.telegrambot.request.SetWebhook;
import com.pengrad.telegrambot.response.BaseResponse;
import io.javalin.Javalin;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelegramWebhookService
implements TelegramService {
    private static final Logger log = LoggerFactory.getLogger(TelegramWebhookService.class);
    private final TelegramBot telegramBot;
    private final TelegramBotProperties botProperties;
    private final TelegramUpdatesHandler updatesHandler;
    private final Javalin server;

    public TelegramWebhookService(@NotNull TelegramBotProperties botProperties, TelegramBot bot, @NotNull TelegramUpdatesHandler updatesHandler, @NotNull Javalin server) {
        this.botProperties = botProperties;
        this.updatesHandler = updatesHandler;
        this.server = server;
        this.telegramBot = bot;
    }

    @Override
    public void start() {
        String endpoint = this.getEndpoint(this.botProperties.getWebhook());
        String url = (String)this.botProperties.getWebhook().getParameters().get("url");
        try {
            BaseResponse response = this.telegramBot.execute((BaseRequest)this.botProperties.getWebhook());
            if (!response.isOk()) {
                throw new IllegalStateException();
            }
            log.info("Webhook '{}' has been enabled", (Object)url);
        }
        catch (Exception ex) {
            log.error("Webhook '{}' couldn't be enabled", (Object)url);
            throw ex;
        }
        try {
            this.registerEndpoint(endpoint);
            log.info("Endpoint '{}' has been created", (Object)endpoint);
        }
        catch (Exception ex) {
            log.error("An unexpected error occured while adding webhook endpoint", (Throwable)ex);
            throw ex;
        }
    }

    private void registerEndpoint(String endpoint) {
        this.server.post(endpoint, context -> {
            List<Update> updates = null;
            try {
                Update update = BotUtils.parseUpdate((String)context.body());
                updates = Collections.singletonList(update);
            }
            catch (Exception ex) {
                log.error("Telegram updates can't be parsed for '{}' webhook", (Object)endpoint);
            }
            if (updates != null) {
                this.updatesHandler.processUpdates(this.botProperties.getToken(), this.telegramBot, updates);
            }
        });
    }

    private String getEndpoint(SetWebhook setWebhook) {
        String url = (String)setWebhook.getParameters().get("url");
        String uuid = UUID.randomUUID().toString();
        try {
            String path = new URL(new URL(url), uuid).toString();
            setWebhook.url(path);
        }
        catch (Exception ex) {
            log.error("Webhook url '{}' can't be parsed", (Object)url);
        }
        return "/" + uuid;
    }

    @Override
    public void stop() {
        if (!this.botProperties.isKeepWebhookRegistration()) {
            log.info("Webhook has been deleted");
            this.telegramBot.execute((BaseRequest)new DeleteWebhook());
        }
    }
}

