/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler.processor;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;

public class HandlerMethod {
    private final Object bean;
    private final Class<?> beanType;
    private final Method method;
    private final Method bridgedMethod;
    private final MethodParameter[] methodParameters;

    public HandlerMethod(@NotNull Object bean, @NotNull Method method) {
        this.bean = bean;
        this.beanType = ClassUtils.getUserClass((Object)bean);
        this.method = method;
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
        this.methodParameters = this.initMethodParameters();
    }

    HandlerMethod(HandlerMethod handlerMethod) {
        this.bean = handlerMethod.bean;
        this.beanType = handlerMethod.beanType;
        this.method = handlerMethod.method;
        this.bridgedMethod = handlerMethod.bridgedMethod;
        this.methodParameters = handlerMethod.methodParameters;
    }

    private MethodParameter[] initMethodParameters() {
        int count = this.bridgedMethod.getParameterCount();
        MethodParameter[] result = new MethodParameter[count];
        for (int i = 0; i < count; ++i) {
            SynthesizingMethodParameter parameter = new SynthesizingMethodParameter(this.bridgedMethod, i);
            GenericTypeResolver.resolveParameterType((MethodParameter)parameter, this.beanType);
            result[i] = parameter;
        }
        return result;
    }

    public MethodParameter getReturnValue(@Nullable Object returnValue) {
        return new ReturnValueMethodParameter(returnValue);
    }

    public String toString() {
        return this.bridgedMethod.getDeclaringClass().getTypeName() + '.' + this.bridgedMethod.getName();
    }

    public Object getBean() {
        return this.bean;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public Method getMethod() {
        return this.method;
    }

    public Method getBridgedMethod() {
        return this.bridgedMethod;
    }

    public MethodParameter[] getMethodParameters() {
        return this.methodParameters;
    }

    private class ReturnValueMethodParameter
    extends MethodParameter {
        @Nullable
        private final Object returnValue;

        ReturnValueMethodParameter(Object returnValue) {
            super(HandlerMethod.this.bridgedMethod, -1);
            this.returnValue = returnValue;
        }

        ReturnValueMethodParameter(ReturnValueMethodParameter original) {
            super((MethodParameter)original);
            this.returnValue = original.returnValue;
        }

        @NonNull
        public Class<?> getParameterType() {
            return this.returnValue != null ? this.returnValue.getClass() : super.getParameterType();
        }

        @NonNull
        public ReturnValueMethodParameter clone() {
            return new ReturnValueMethodParameter(this);
        }
    }
}

