/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler.processor;

import com.codahale.metrics.Timer;
import com.github.kshashov.telegram.TelegramSessionResolver;
import com.github.kshashov.telegram.api.TelegramRequest;
import com.github.kshashov.telegram.api.TelegramSession;
import com.github.kshashov.telegram.handler.HandlerMethodContainer;
import com.github.kshashov.telegram.handler.processor.HandlerMethod;
import com.github.kshashov.telegram.handler.processor.TelegramCallback;
import com.github.kshashov.telegram.handler.processor.TelegramEvent;
import com.github.kshashov.telegram.handler.processor.TelegramInvocableHandlerMethod;
import com.github.kshashov.telegram.handler.processor.arguments.BotHandlerMethodArgumentResolver;
import com.github.kshashov.telegram.handler.processor.response.BotHandlerMethodReturnValueHandler;
import com.github.kshashov.telegram.metrics.MetricsService;
import com.pengrad.telegrambot.request.BaseRequest;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDispatcher {
    private static final Logger log = LoggerFactory.getLogger(RequestDispatcher.class);
    private final HandlerMethodContainer handlerMethodContainer;
    private final TelegramSessionResolver sessionResolver;
    private final BotHandlerMethodArgumentResolver argumentResolver;
    private final BotHandlerMethodReturnValueHandler returnValueHandler;
    private final MetricsService metricsService;

    public RequestDispatcher(@NotNull HandlerMethodContainer handlerMethodContainer, @NotNull TelegramSessionResolver sessionResolver, @NotNull BotHandlerMethodArgumentResolver argumentResolver, @NotNull BotHandlerMethodReturnValueHandler returnValueHandler, @NotNull MetricsService metricsService) {
        this.handlerMethodContainer = handlerMethodContainer;
        this.sessionResolver = sessionResolver;
        this.argumentResolver = argumentResolver;
        this.returnValueHandler = returnValueHandler;
        this.metricsService = metricsService;
    }

    public TelegramCallback execute(@NotNull TelegramEvent event) throws IllegalStateException {
        TelegramSessionResolver.TelegramSessionHolder sessionHolder = null;
        HandlerMethodContainer.HandlerLookupResult lookupResult = this.handlerMethodContainer.lookupHandlerMethod(event);
        HandlerMethod method = lookupResult.getHandlerMethod();
        try {
            sessionHolder = this.sessionResolver.resolveTelegramSession(event);
            if (method == null) {
                log.debug("Not found controller for {} (type {})", (Object)event.getText(), (Object)event.getMessageType());
                this.metricsService.onNoHandlersFound();
                TelegramCallback telegramCallback = null;
                return telegramCallback;
            }
            Timer.Context timerContext = this.metricsService.onMethodHandlerStarted(method);
            TelegramRequest request = new TelegramRequest(event.getTelegramBot(), event.getUpdate(), event.getMessageType(), lookupResult.getBasePattern(), lookupResult.getTemplateVariables(), event.getMessage(), event.getText(), event.getChat(), event.getUser());
            BaseRequest result = this.doExecute(request, lookupResult, sessionHolder.getSession());
            this.metricsService.onUpdateSuccess(method, timerContext);
            TelegramCallback telegramCallback = result == null ? null : new TelegramCallback(result, request.getCallback());
            return telegramCallback;
        }
        catch (Exception ex) {
            if (method != null) {
                this.metricsService.onUpdateError(method);
            }
            throw ex;
        }
        finally {
            if (sessionHolder != null) {
                sessionHolder.releaseSessionId();
            }
        }
    }

    private BaseRequest doExecute(TelegramRequest request, @NotNull HandlerMethodContainer.HandlerLookupResult lookupResult, @NotNull TelegramSession session) throws IllegalStateException {
        BaseRequest result = new TelegramInvocableHandlerMethod(lookupResult.getHandlerMethod(), this.argumentResolver, this.returnValueHandler).invokeAndHandle(request, session);
        log.info("{} request has been executed by '{}' handler method with {} result", new Object[]{request.getMessageType(), lookupResult.getHandlerMethod().toString(), result == null ? "null" : result.getClass().getSimpleName()});
        return result;
    }
}

