/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler.processor;

import com.github.kshashov.telegram.api.MessageType;
import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.model.CallbackQuery;
import com.pengrad.telegrambot.model.Chat;
import com.pengrad.telegrambot.model.ChosenInlineResult;
import com.pengrad.telegrambot.model.InlineQuery;
import com.pengrad.telegrambot.model.Message;
import com.pengrad.telegrambot.model.PreCheckoutQuery;
import com.pengrad.telegrambot.model.ShippingQuery;
import com.pengrad.telegrambot.model.Update;
import com.pengrad.telegrambot.model.User;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class TelegramEvent {
    @NotNull
    private final Update update;
    @Nullable
    private final Message message;
    @Nullable
    private final Chat chat;
    @Nullable
    private final User user;
    @Nullable
    private final String text;
    @NotNull
    private final TelegramBot telegramBot;
    @NotNull
    private final MessageType messageType;
    private final String token;

    public TelegramEvent(@NotNull String token, @NotNull Update update, @NotNull TelegramBot telegramBot) {
        this.token = token;
        this.telegramBot = telegramBot;
        this.update = update;
        this.message = TelegramEvent.firstNonNull(update.message(), update.editedMessage(), update.channelPost(), update.editedChannelPost());
        if (this.message != null) {
            this.user = TelegramEvent.firstNonNull(this.message.from(), this.message.leftChatMember(), this.message.forwardFrom());
            this.chat = TelegramEvent.firstNonNull(this.message.chat(), this.message.forwardFromChat());
            this.text = this.message.text();
            this.messageType = update.editedMessage() != null ? MessageType.EDITED_MESSAGE : (update.channelPost() != null ? MessageType.CHANNEL_POST : (update.editedChannelPost() != null ? MessageType.EDITED_CHANNEL_POST : MessageType.MESSAGE));
        } else if (update.inlineQuery() != null) {
            InlineQuery inlineQuery = update.inlineQuery();
            this.user = inlineQuery.from();
            this.text = inlineQuery.query();
            this.chat = null;
            this.messageType = MessageType.INLINE_QUERY;
        } else if (update.chosenInlineResult() != null) {
            ChosenInlineResult chosenInlineResult = update.chosenInlineResult();
            this.user = chosenInlineResult.from();
            this.text = chosenInlineResult.query();
            this.chat = null;
            this.messageType = MessageType.CHOSEN_INLINE_RESULT;
        } else if (update.callbackQuery() != null) {
            CallbackQuery callbackQuery = update.callbackQuery();
            this.user = callbackQuery.from();
            this.text = callbackQuery.data();
            this.chat = callbackQuery.message().chat();
            this.messageType = MessageType.CALLBACK_QUERY;
        } else if (update.shippingQuery() != null) {
            ShippingQuery shippingQuery = update.shippingQuery();
            this.user = shippingQuery.from();
            this.text = shippingQuery.invoicePayload();
            this.chat = null;
            this.messageType = MessageType.SHIPPING_QUERY;
        } else if (update.preCheckoutQuery() != null) {
            PreCheckoutQuery preCheckoutQuery = update.preCheckoutQuery();
            this.user = preCheckoutQuery.from();
            this.text = preCheckoutQuery.invoicePayload();
            this.chat = null;
            this.messageType = MessageType.PRECHECKOUT_QUERY;
        } else if (update.poll() != null) {
            this.user = null;
            this.text = update.poll().question();
            this.chat = null;
            this.messageType = MessageType.POLL;
        } else {
            this.user = null;
            this.text = null;
            this.chat = null;
            this.messageType = MessageType.UNSUPPORTED;
        }
    }

    @SafeVarargs
    private static <T> T firstNonNull(T ... messages) {
        for (T message : messages) {
            if (message == null) continue;
            return message;
        }
        return null;
    }

    @NotNull
    public Update getUpdate() {
        return this.update;
    }

    @Nullable
    public Message getMessage() {
        return this.message;
    }

    @Nullable
    public Chat getChat() {
        return this.chat;
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @NotNull
    public TelegramBot getTelegramBot() {
        return this.telegramBot;
    }

    @NotNull
    public MessageType getMessageType() {
        return this.messageType;
    }

    public String getToken() {
        return this.token;
    }
}

