/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler.processor;

import com.github.kshashov.telegram.api.TelegramRequest;
import com.github.kshashov.telegram.api.TelegramSession;
import com.github.kshashov.telegram.handler.processor.HandlerMethod;
import com.github.kshashov.telegram.handler.processor.arguments.BotHandlerMethodArgumentResolver;
import com.github.kshashov.telegram.handler.processor.response.BotHandlerMethodReturnValueHandler;
import com.pengrad.telegrambot.request.BaseRequest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class TelegramInvocableHandlerMethod
extends HandlerMethod {
    private static final Logger log = LoggerFactory.getLogger(TelegramInvocableHandlerMethod.class);
    private final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final BotHandlerMethodArgumentResolver argumentResolver;
    private final BotHandlerMethodReturnValueHandler returnValueHandler;

    public TelegramInvocableHandlerMethod(@NotNull HandlerMethod handlerMethod, @NotNull BotHandlerMethodArgumentResolver argumentResolver, @NotNull BotHandlerMethodReturnValueHandler returnValueHandler) {
        super(handlerMethod);
        this.argumentResolver = argumentResolver;
        this.returnValueHandler = returnValueHandler;
    }

    public BaseRequest invokeAndHandle(@NotNull TelegramRequest telegramRequest, @NotNull TelegramSession telegramSession) throws IllegalStateException {
        Object[] args = this.getMethodArgumentValues(telegramRequest, telegramSession);
        if (log.isTraceEnabled()) {
            log.trace("Invoking '" + ClassUtils.getQualifiedMethodName((Method)this.getMethod(), this.getBeanType()) + "' with arguments " + Arrays.toString(args));
        }
        Object returnValue = this.doSafeInvoke(args);
        if (log.isTraceEnabled()) {
            log.trace("Method [" + ClassUtils.getQualifiedMethodName((Method)this.getMethod(), this.getBeanType()) + "] returned [" + returnValue + "]");
        }
        return this.returnValueHandler.handleReturnValue(returnValue, this.getReturnValue(returnValue), telegramRequest);
    }

    private Object doSafeInvoke(Object[] args) throws IllegalStateException {
        ReflectionUtils.makeAccessible((Method)this.getBridgedMethod());
        try {
            return this.getBridgedMethod().invoke(this.getBean(), args);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            String text = this.getInvocationErrorMessage("Failed to invoke handler method", args);
            throw new IllegalStateException(text, targetException);
        }
        catch (Exception ex) {
            String text = ex.getMessage() != null ? ex.getMessage() : "";
            throw new IllegalStateException(this.getInvocationErrorMessage(text, args), ex);
        }
    }

    private Object[] getMethodArgumentValues(@NotNull TelegramRequest telegramRequest, @NotNull TelegramSession telegramSession) {
        MethodParameter[] parameters = this.getMethodParameters();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter parameter = parameters[i];
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            args[i] = this.argumentResolver.resolveArgument(parameter, telegramRequest, telegramSession);
        }
        return args;
    }

    private String getInvocationErrorMessage(String text, Object[] resolvedArgs) {
        StringBuilder sb = new StringBuilder(text).append("\n");
        sb.append("HandlerMethod details: \n");
        sb.append("Controller [").append(this.getBeanType().getName()).append("]\n");
        sb.append("Method [").append(this.getBridgedMethod().toGenericString()).append("]\n");
        sb.append("Resolved arguments: \n");
        for (int i = 0; i < resolvedArgs.length; ++i) {
            sb.append("[").append(i).append("] ");
            if (resolvedArgs[i] == null) {
                sb.append("[null] \n");
                continue;
            }
            sb.append("[type=").append(resolvedArgs[i].getClass().getName()).append("] ");
            sb.append("[value=").append(resolvedArgs[i]).append("]\n");
        }
        return sb.toString();
    }
}

