/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler.processor.arguments;

import com.github.kshashov.telegram.api.TelegramRequest;
import com.github.kshashov.telegram.api.TelegramSession;
import com.github.kshashov.telegram.handler.processor.arguments.BotHandlerMethodArgumentResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;

public class BotHandlerMethodArgumentResolverComposite
implements BotHandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(BotHandlerMethodArgumentResolverComposite.class);
    private final List<BotHandlerMethodArgumentResolver> argumentResolvers;
    private final Map<MethodParameter, BotHandlerMethodArgumentResolver> argumentResolverCache = new ConcurrentHashMap<MethodParameter, BotHandlerMethodArgumentResolver>(256);

    public BotHandlerMethodArgumentResolverComposite(@NotNull List<BotHandlerMethodArgumentResolver> resolvers) {
        this.argumentResolvers = new ArrayList<BotHandlerMethodArgumentResolver>(resolvers);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.getArgumentResolver(parameter) != null;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, TelegramRequest telegramRequest, TelegramSession telegramSession) {
        BotHandlerMethodArgumentResolver resolver = this.getArgumentResolver(parameter);
        if (resolver == null) {
            log.error("Unknown parameter type [" + parameter.getParameterType().getName() + "]");
            return null;
        }
        return resolver.resolveArgument(parameter, telegramRequest, telegramSession);
    }

    private BotHandlerMethodArgumentResolver getArgumentResolver(MethodParameter parameter) {
        BotHandlerMethodArgumentResolver result = this.argumentResolverCache.get(parameter);
        if (result == null) {
            for (BotHandlerMethodArgumentResolver methodArgumentResolver : this.argumentResolvers) {
                if (log.isTraceEnabled()) {
                    log.trace("Testing if argument resolver [" + methodArgumentResolver + "] supports [" + parameter.getGenericParameterType() + "]");
                }
                if (!methodArgumentResolver.supportsParameter(parameter)) continue;
                result = methodArgumentResolver;
                this.argumentResolverCache.put(parameter, result);
                break;
            }
        }
        return result;
    }
}

