/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler.processor.arguments;

import com.github.kshashov.telegram.api.TelegramRequest;
import com.github.kshashov.telegram.api.TelegramSession;
import com.github.kshashov.telegram.api.bind.annotation.BotPathVariable;
import com.github.kshashov.telegram.handler.processor.arguments.BotHandlerMethodArgumentResolver;
import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.model.CallbackQuery;
import com.pengrad.telegrambot.model.Chat;
import com.pengrad.telegrambot.model.ChosenInlineResult;
import com.pengrad.telegrambot.model.InlineQuery;
import com.pengrad.telegrambot.model.Message;
import com.pengrad.telegrambot.model.Poll;
import com.pengrad.telegrambot.model.PreCheckoutQuery;
import com.pengrad.telegrambot.model.ShippingQuery;
import com.pengrad.telegrambot.model.Update;
import com.pengrad.telegrambot.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;

public class BotRequestMethodArgumentResolver
implements BotHandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(BotRequestMethodArgumentResolver.class);

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(BotPathVariable.class)) {
            return false;
        }
        Class paramType = parameter.getParameterType();
        return TelegramRequest.class.isAssignableFrom(paramType) || TelegramSession.class.isAssignableFrom(paramType) || TelegramBot.class.isAssignableFrom(paramType) || String.class.isAssignableFrom(paramType) || Update.class.isAssignableFrom(paramType) || Message.class.isAssignableFrom(paramType) || InlineQuery.class.isAssignableFrom(paramType) || ChosenInlineResult.class.isAssignableFrom(paramType) || CallbackQuery.class.isAssignableFrom(paramType) || ShippingQuery.class.isAssignableFrom(paramType) || PreCheckoutQuery.class.isAssignableFrom(paramType) || Poll.class.isAssignableFrom(paramType) || Chat.class.isAssignableFrom(paramType) || User.class.isAssignableFrom(paramType);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, TelegramRequest telegramRequest, TelegramSession telegramSession) {
        Class paramType = parameter.getParameterType();
        if (TelegramRequest.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, telegramRequest);
        }
        if (TelegramSession.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, telegramSession);
        }
        if (TelegramBot.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, telegramRequest.getTelegramBot());
        }
        if (Update.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, telegramRequest.getUpdate());
        }
        if (Message.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, telegramRequest.getMessage());
        }
        if (User.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, telegramRequest.getUser());
        }
        if (Chat.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, telegramRequest.getChat());
        }
        if (String.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, telegramRequest.getText());
        }
        Update update = telegramRequest.getUpdate();
        if (update == null) {
            return null;
        }
        if (CallbackQuery.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, update.callbackQuery());
        }
        if (InlineQuery.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, update.inlineQuery());
        }
        if (ChosenInlineResult.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, update.chosenInlineResult());
        }
        if (ShippingQuery.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, update.shippingQuery());
        }
        if (PreCheckoutQuery.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, update.preCheckoutQuery());
        }
        if (Poll.class.isAssignableFrom(paramType)) {
            return this.validateValue(paramType, update.poll());
        }
        return null;
    }

    private Object validateValue(Class<?> paramType, Object value) {
        if (value != null && !paramType.isInstance(value)) {
            log.error("Current request is not of type [" + paramType.getName() + "]: " + value + "");
            return null;
        }
        return value;
    }
}

