/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler.processor.arguments;

import com.github.kshashov.telegram.api.TelegramRequest;
import com.github.kshashov.telegram.api.TelegramSession;
import com.github.kshashov.telegram.api.bind.annotation.BotPathVariable;
import com.github.kshashov.telegram.handler.processor.arguments.BotHandlerMethodArgumentResolver;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;

public class BotRequestMethodPathArgumentResolver
implements BotHandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(BotRequestMethodPathArgumentResolver.class);

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        return parameter.hasParameterAnnotation(BotPathVariable.class) && (String.class.isAssignableFrom(paramType) || Integer.class.isAssignableFrom(paramType) || Long.class.isAssignableFrom(paramType) || Double.class.isAssignableFrom(paramType) || Float.class.isAssignableFrom(paramType) || BigInteger.class.isAssignableFrom(paramType) || BigDecimal.class.isAssignableFrom(paramType));
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, TelegramRequest telegramRequest, TelegramSession telegramSession) {
        Class paramType = parameter.getParameterType();
        BotPathVariable annotation = (BotPathVariable)parameter.getParameterAnnotation(BotPathVariable.class);
        if (telegramRequest.getTemplateVariables() == null || annotation == null) {
            return null;
        }
        String value = annotation.value().isEmpty() ? telegramRequest.getTemplateVariables().get(parameter.getParameterName()) : telegramRequest.getTemplateVariables().get(annotation.value());
        if (value == null) {
            return null;
        }
        try {
            if (String.class.isAssignableFrom(paramType)) {
                return this.validateValue(paramType, value);
            }
            if (Integer.class.isAssignableFrom(paramType)) {
                return this.validateValue(paramType, new Integer(value));
            }
            if (Long.class.isAssignableFrom(paramType)) {
                return this.validateValue(paramType, new Long(value));
            }
            if (Double.class.isAssignableFrom(paramType)) {
                return this.validateValue(paramType, new Double(value));
            }
            if (Float.class.isAssignableFrom(paramType)) {
                return this.validateValue(paramType, new Float(value));
            }
            if (BigInteger.class.isAssignableFrom(paramType)) {
                return this.validateValue(paramType, new BigInteger(value));
            }
            if (BigDecimal.class.isAssignableFrom(paramType)) {
                return this.validateValue(paramType, new BigDecimal(value));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private Object validateValue(Class<?> paramType, Object value) {
        if (value != null && !paramType.isInstance(value)) {
            log.error("Current request is not of type [" + paramType.getName() + "]: " + value + "");
            return null;
        }
        return value;
    }
}

