/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler.processor.response;

import com.github.kshashov.telegram.api.TelegramRequest;
import com.github.kshashov.telegram.handler.processor.response.BotHandlerMethodReturnValueHandler;
import com.pengrad.telegrambot.request.BaseRequest;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;

public class BotHandlerMethodReturnValueHandlerComposite
implements BotHandlerMethodReturnValueHandler {
    private static final Logger log = LoggerFactory.getLogger(BotHandlerMethodReturnValueHandlerComposite.class);
    private final List<BotHandlerMethodReturnValueHandler> returnValueHandlers;

    public BotHandlerMethodReturnValueHandlerComposite(@NotNull List<BotHandlerMethodReturnValueHandler> handlers) {
        this.returnValueHandlers = new ArrayList<BotHandlerMethodReturnValueHandler>(handlers);
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return this.getReturnValueHandler(returnType) != null;
    }

    private BotHandlerMethodReturnValueHandler getReturnValueHandler(MethodParameter returnType) {
        for (BotHandlerMethodReturnValueHandler handler : this.returnValueHandlers) {
            if (log.isTraceEnabled()) {
                log.trace("Testing if response resolver [" + handler + "] supports [" + returnType.getGenericParameterType() + "]");
            }
            if (!handler.supportsReturnType(returnType)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public BaseRequest handleReturnValue(Object returnValue, MethodParameter returnType, TelegramRequest telegramRequest) {
        BotHandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        if (handler == null) {
            log.error("Unknown return value type: " + returnType.getParameterType().getName());
            return null;
        }
        return handler.handleReturnValue(returnValue, returnType, telegramRequest);
    }
}

