/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.handler.processor.response;

import com.github.kshashov.telegram.api.TelegramRequest;
import com.github.kshashov.telegram.handler.processor.response.BotHandlerMethodReturnValueHandler;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.request.SendMessage;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;

public class BotResponseBodyMethodProcessor
implements BotHandlerMethodReturnValueHandler {
    private final ConversionService conversionService;

    public BotResponseBodyMethodProcessor(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return true;
    }

    @Override
    public BaseRequest handleReturnValue(Object returnValue, MethodParameter returnType, TelegramRequest telegramRequest) {
        String outputValue = null;
        if (returnValue instanceof CharSequence) {
            outputValue = returnValue.toString();
        } else {
            Class valueType;
            Class clazz = valueType = returnValue != null ? returnValue.getClass() : returnType.getParameterType();
            if (this.conversionService.canConvert(valueType, String.class)) {
                outputValue = (String)this.conversionService.convert(returnValue, String.class);
            }
        }
        if (outputValue != null && telegramRequest.getChat() != null) {
            return new SendMessage((Object)telegramRequest.getChat().id(), outputValue);
        }
        return null;
    }
}

