/*
 * Decompiled with CFR 0.152.
 */
package com.github.kshashov.telegram.metrics;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingWindowReservoir;
import com.codahale.metrics.Timer;
import com.github.kshashov.telegram.handler.processor.HandlerMethod;

public class MetricsService {
    public static final String UPDATES_RECEIVED = "updates";
    public static final String UPDATE_ERRORS = "processing.errors";
    public static final String NO_HANDLERS_ERRORS = "no.handlers.errors";
    public static final String HANDLER_ERRORS = "handler.%s.errors";
    public static final String HANDLER_SUCCESSES = "handler.%s.successes";
    public static final String HANDLER_EXECUTION_TIME = "handler.%s.execution.time";
    private final MetricRegistry metricRegistry;

    public MetricsService(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        metricRegistry.register(UPDATES_RECEIVED, (Metric)new Meter());
        metricRegistry.register(UPDATE_ERRORS, (Metric)new Meter());
        metricRegistry.register(NO_HANDLERS_ERRORS, (Metric)new Meter());
    }

    public void onUpdatesReceived(int messages) {
        ((Meter)this.metricRegistry.getMeters().get(UPDATES_RECEIVED)).mark((long)messages);
    }

    public void onNoHandlersFound() {
        ((Meter)this.metricRegistry.getMeters().get(NO_HANDLERS_ERRORS)).mark();
    }

    public void onUpdateError() {
        ((Meter)this.metricRegistry.getMeters().get(UPDATE_ERRORS)).mark();
    }

    public void registerHandlerMethod(HandlerMethod method) {
        this.metricRegistry.register(String.format(HANDLER_ERRORS, this.getMethodName(method)), (Metric)new Meter());
        this.metricRegistry.register(String.format(HANDLER_EXECUTION_TIME, this.getMethodName(method)), (Metric)new Timer((Reservoir)new SlidingWindowReservoir(64)));
        this.metricRegistry.register(String.format(HANDLER_SUCCESSES, this.getMethodName(method)), (Metric)new Meter());
    }

    public Timer.Context onMethodHandlerStarted(HandlerMethod method) {
        return ((Timer)this.metricRegistry.getTimers().get(String.format(HANDLER_EXECUTION_TIME, this.getMethodName(method)))).time();
    }

    public void onUpdateError(HandlerMethod method) {
        ((Meter)this.metricRegistry.getMeters().get(String.format(HANDLER_ERRORS, this.getMethodName(method)))).mark();
    }

    public void onUpdateSuccess(HandlerMethod method, Timer.Context timerContext) {
        ((Meter)this.metricRegistry.getMeters().get(String.format(HANDLER_SUCCESSES, this.getMethodName(method)))).mark();
        timerContext.close();
    }

    private String getMethodName(HandlerMethod method) {
        return method.getBeanType().getName() + "." + method.getBridgedMethod().getName();
    }
}

