/*
 * Decompiled with CFR 0.152.
 */
package com.github.kuliginstepan.outbox.mongodb.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kuliginstepan.outbox.core.DefaultOutboxRepublisher;
import com.github.kuliginstepan.outbox.core.OutboxAspect;
import com.github.kuliginstepan.outbox.core.OutboxEntityFactory;
import com.github.kuliginstepan.outbox.core.OutboxRepository;
import com.github.kuliginstepan.outbox.core.OutboxRepublisher;
import com.github.kuliginstepan.outbox.mongodb.autoconfigure.CommonOutboxConfiguration;
import com.github.kuliginstepan.outbox.mongodb.autoconfigure.ExtendedMongoOutboxProperties;
import com.github.kuliginstepan.outbox.mongodb.autoconfigure.MongoOutboxRepository;
import com.mongodb.client.MongoClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={MongoDataAutoConfiguration.class, JacksonAutoConfiguration.class})
@Import(value={CommonOutboxConfiguration.class})
@ConditionalOnClass(value={MongoTemplate.class, ObjectMapper.class, MongoClient.class})
public class MongoOutboxAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OutboxRepository mongoOutboxRepository(MongoTemplate template, ObjectMapper mapper, ExtendedMongoOutboxProperties properties) {
        return new MongoOutboxRepository(template, mapper, properties.getMongodb());
    }

    @Bean
    @ConditionalOnMissingBean
    public OutboxAspect outboxAspect(OutboxEntityFactory factory, OutboxRepository repository, ObjectProvider<ThreadPoolTaskExecutor> executor) {
        return new OutboxAspect(factory, repository, (TaskExecutor)executor.getIfAvailable(() -> {
            ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
            taskExecutor.initialize();
            return taskExecutor;
        }));
    }

    @Bean
    @ConditionalOnMissingBean
    public OutboxRepublisher mongoOutboxRepublisher(OutboxRepository repository, ExtendedMongoOutboxProperties properties) {
        return new DefaultOutboxRepublisher(repository, properties.getNotAfterPolicy());
    }
}

