/*
 * Decompiled with CFR 0.152.
 */
package com.github.kuliginstepan.outbox.mongodb.autoconfigure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kuliginstepan.outbox.core.OutboxEntity;
import com.github.kuliginstepan.outbox.core.OutboxMethodIdentifier;
import com.github.kuliginstepan.outbox.core.OutboxRepository;
import com.github.kuliginstepan.outbox.mongodb.autoconfigure.ExtendedMongoOutboxProperties;
import com.github.kuliginstepan.outbox.mongodb.autoconfigure.MongoOutboxEntity;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.util.ClassUtils;

public class MongoOutboxRepository
implements OutboxRepository {
    private final MongoTemplate template;
    private final ObjectMapper mapper;
    private final ExtendedMongoOutboxProperties.MongoOutboxProperties properties;

    public void save(OutboxEntity entity) {
        MongoOutboxEntity outboxEntity = new MongoOutboxEntity();
        outboxEntity.setOutboxMethodId(entity.getMethodIdentifier().getValue());
        outboxEntity.setPublicationDate(Instant.now());
        outboxEntity.setData(this.serialize(entity.getData()));
        outboxEntity.setDataType(ClassUtils.getQualifiedName(entity.getData().getClass()));
        this.template.save((Object)outboxEntity, this.properties.getCollection());
    }

    public void markCompleted(OutboxEntity entity) {
        this.template.update(MongoOutboxEntity.class).inCollection(this.properties.getCollection()).matching(Query.query((CriteriaDefinition)Criteria.where((String)"outboxMethodId").is((Object)entity.getMethodIdentifier().getValue()).and("data").is((Object)this.serialize(entity.getData())).and("completionDate").exists(false))).apply((UpdateDefinition)Update.update((String)"completionDate", (Object)Instant.now())).all();
    }

    public List<OutboxEntity> findUncompletedEntities(Instant notAfterDate) {
        return this.template.find(Query.query((CriteriaDefinition)Criteria.where((String)"completionDate").exists(false).and("publicationDate").lte((Object)notAfterDate)), MongoOutboxEntity.class, this.properties.getCollection()).stream().map(entity -> new OutboxEntity(){
            final /* synthetic */ MongoOutboxEntity val$entity;
            {
                this.val$entity = mongoOutboxEntity;
            }

            public OutboxMethodIdentifier getMethodIdentifier() {
                return OutboxMethodIdentifier.of((String)this.val$entity.getOutboxMethodId());
            }

            public Object getData() {
                return MongoOutboxRepository.this.deserialize(this.val$entity.getData(), ClassUtils.resolveClassName((String)this.val$entity.getDataType(), (ClassLoader)MongoOutboxRepository.class.getClassLoader()));
            }
        }).collect(Collectors.toList());
    }

    private String serialize(Object o) {
        try {
            return this.mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private Object deserialize(String data, Class<?> type) {
        try {
            return this.mapper.readValue(data, type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public MongoOutboxRepository(MongoTemplate template, ObjectMapper mapper, ExtendedMongoOutboxProperties.MongoOutboxProperties properties) {
        this.template = template;
        this.mapper = mapper;
        this.properties = properties;
    }
}

