/*
 * Decompiled with CFR 0.152.
 */
package com.github.kuliginstepan.outbox.mongodb.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kuliginstepan.outbox.core.DefaultReactiveOutboxRepublisher;
import com.github.kuliginstepan.outbox.core.OutboxEntityFactory;
import com.github.kuliginstepan.outbox.core.ReactiveOutboxAspect;
import com.github.kuliginstepan.outbox.core.ReactiveOutboxRepository;
import com.github.kuliginstepan.outbox.core.ReactiveOutboxRepublisher;
import com.github.kuliginstepan.outbox.mongodb.autoconfigure.CommonOutboxConfiguration;
import com.github.kuliginstepan.outbox.mongodb.autoconfigure.ExtendedMongoOutboxProperties;
import com.github.kuliginstepan.outbox.mongodb.autoconfigure.ReactiveMongoOutboxRepository;
import com.mongodb.reactivestreams.client.MongoClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.mongo.MongoReactiveDataAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import reactor.core.scheduler.Schedulers;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={MongoReactiveDataAutoConfiguration.class, JacksonAutoConfiguration.class})
@Import(value={CommonOutboxConfiguration.class})
@ConditionalOnClass(value={ReactiveMongoTemplate.class, ObjectMapper.class, MongoClient.class})
public class ReactiveMongoOutboxAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ReactiveOutboxRepository mongoReactiveOutboxRepository(ReactiveMongoTemplate template, ObjectMapper mapper, ExtendedMongoOutboxProperties properties) {
        return new ReactiveMongoOutboxRepository(template, mapper, properties.getMongodb());
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveOutboxAspect reactiveOutboxAspect(OutboxEntityFactory factory, ReactiveOutboxRepository repository) {
        return new ReactiveOutboxAspect(factory, repository, Schedulers.boundedElastic());
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveOutboxRepublisher mongoReactiveOutboxRepublisher(ReactiveOutboxRepository repository, ExtendedMongoOutboxProperties properties) {
        return new DefaultReactiveOutboxRepublisher(repository, properties.getNotAfterPolicy());
    }
}

