/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.excel.jxl;

import java.io.InputStream;
import jxl.Workbook;
import jxl.read.biff.WorkbookParser;
import org.springframework.batch.item.excel.AbstractExcelItemReader;
import org.springframework.batch.item.excel.Sheet;
import org.springframework.batch.item.excel.jxl.JxlSheet;
import org.springframework.util.ClassUtils;

public class JxlItemReader<T>
extends AbstractExcelItemReader<T> {
    private Workbook workbook;

    public JxlItemReader() {
        this.setName(ClassUtils.getShortName(JxlItemReader.class));
    }

    @Override
    protected void openExcelFile(InputStream inputStream) throws Exception {
        this.workbook = WorkbookParser.getWorkbook((InputStream)inputStream);
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        if (this.workbook != null) {
            this.workbook.close();
        }
        this.workbook = null;
    }

    @Override
    protected Sheet getSheet(int sheet) {
        if (sheet < this.workbook.getNumberOfSheets()) {
            return new JxlSheet(this.workbook.getSheet(sheet));
        }
        return null;
    }

    @Override
    protected int getNumberOfSheets() {
        if (this.workbook == null) {
            throw new IllegalStateException("Workbook file not ready for reading!");
        }
        return this.workbook.getNumberOfSheets();
    }
}

