/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.excel.poi;

import java.io.InputStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.batch.item.excel.AbstractExcelItemReader;
import org.springframework.batch.item.excel.Sheet;
import org.springframework.batch.item.excel.poi.DefaulltMappingPoiSheet;
import org.springframework.batch.item.excel.poi.PoiSheet;

public class PoiItemReader<T>
extends AbstractExcelItemReader<T> {
    private Workbook workbook;
    private boolean useDefaultCellType;

    @Override
    protected Sheet getSheet(int sheet) {
        if (this.useDefaultCellType) {
            return new DefaulltMappingPoiSheet(this.workbook.getSheetAt(sheet));
        }
        return new PoiSheet(this.workbook.getSheetAt(sheet));
    }

    public PoiItemReader() {
    }

    public PoiItemReader(boolean useDefaultCellType) {
        this.useDefaultCellType = useDefaultCellType;
    }

    @Override
    protected int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        if (this.workbook != null) {
            this.workbook.close();
        }
        this.workbook = null;
    }

    @Override
    protected void openExcelFile(InputStream inputStream) throws Exception {
        this.workbook = WorkbookFactory.create((InputStream)inputStream);
        this.workbook.setMissingCellPolicy(Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
    }
}

