/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.excel.poi;

import java.util.Date;
import java.util.LinkedList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.batch.item.excel.Sheet;

class PoiSheet
implements Sheet {
    protected final org.apache.poi.ss.usermodel.Sheet delegate;
    private final int numberOfRows;
    private final String name;
    private FormulaEvaluator evaluator;

    PoiSheet(org.apache.poi.ss.usermodel.Sheet delegate) {
        this.delegate = delegate;
        this.numberOfRows = this.delegate.getLastRowNum() + 1;
        this.name = this.delegate.getSheetName();
    }

    @Override
    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getRow(int rowNumber) {
        Row row = this.delegate.getRow(rowNumber);
        if (row == null) {
            return null;
        }
        LinkedList<String> cells = new LinkedList<String>();
        int numberOfColumns = row.getLastCellNum();
        block6: for (int i = 0; i < numberOfColumns; ++i) {
            Cell cell = row.getCell(i);
            CellType cellType = cell.getCellTypeEnum();
            if (cellType == CellType.FORMULA) {
                FormulaEvaluator evaluator = this.getFormulaEvaluator();
                if (evaluator == null) {
                    cells.add(cell.getCellFormula());
                } else {
                    cellType = evaluator.evaluateFormulaCellEnum(cell);
                }
            }
            switch (cellType) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        cells.add(String.valueOf(date.getTime()));
                        continue block6;
                    }
                    cells.add(String.valueOf(cell.getNumericCellValue()));
                    continue block6;
                }
                case BOOLEAN: {
                    cells.add(String.valueOf(cell.getBooleanCellValue()));
                    continue block6;
                }
                case STRING: 
                case BLANK: {
                    cells.add(cell.getStringCellValue());
                    continue block6;
                }
                case ERROR: {
                    cells.add(FormulaError.forInt((byte)cell.getErrorCellValue()).getString());
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Cannot handle cells of type '" + cell.getCellTypeEnum() + "'");
                }
            }
        }
        return cells.toArray(new String[0]);
    }

    private FormulaEvaluator getFormulaEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.delegate.getWorkbook().getCreationHelper().createFormulaEvaluator();
        }
        return this.evaluator;
    }
}

