/*
 * Decompiled with CFR 0.152.
 */
package com.github.ladutsko.springframework.boot.env;

import com.electronwill.toml.Toml;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class TomlPropertySourceLoader
implements PropertySourceLoader {
    public String[] getFileExtensions() {
        return new String[]{"toml"};
    }

    public List<PropertySource<?>> load(String name, Resource resource) throws IOException {
        try (InputStream in = resource.getInputStream();){
            Map source = Toml.read((InputStream)in);
            if (source.isEmpty()) {
                List<PropertySource<?>> list = Collections.emptyList();
                return list;
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            this.buildFlattenedMap(result, source, null);
            List<MapPropertySource> list = Collections.singletonList(new MapPropertySource(name, result));
            return list;
        }
    }

    private void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String root) {
        boolean rootHasText = null != root && !root.trim().isEmpty();
        source.forEach((key, value) -> {
            String path = rootHasText ? (key.startsWith("[") ? root + key : root + "." + key) : key;
            if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlattenedMap(result, map, path);
            } else if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    this.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), path);
                }
            } else {
                result.put(path, null == value ? "" : value);
            }
        });
    }
}

