/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic;

import com.github.leeonky.dal.util.TextUtil;
import com.github.leeonky.interpreter.StringWithPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Diff {
    private static final String RIGHT_ACTUAL = "Actual:";
    private final String detail;

    public Diff(String prefix, String expected, String actual) {
        this.detail = this.needDiff(expected, actual) ? this.makeDiffDetail(expected, actual, prefix) : "";
    }

    private boolean needDiff(String expected, String actual) {
        return actual != null && (actual.contains("\n") || actual.contains("\r") || expected.contains("\n") || expected.contains("\r"));
    }

    private String makeDiffDetail(String expected, String actual, String leftTitle) {
        String title;
        int position = TextUtil.differentPosition((String)expected, (String)Objects.requireNonNull(actual));
        int titleNewLine = leftTitle.lastIndexOf(10);
        if (titleNewLine == -1) {
            title = "";
        } else {
            title = leftTitle.substring(0, titleNewLine + 1);
            leftTitle = leftTitle.substring(titleNewLine + 1);
        }
        return new SideText(expected, position, leftTitle).merge(new SideText(actual, position, RIGHT_ACTUAL), title);
    }

    public String detail() {
        return this.detail;
    }

    private static class SideText {
        private final String title;
        private final List<String> lines;
        private final int width;

        public SideText(String content, int position, String title) {
            this.title = title;
            this.lines = new ArrayList<String>(TextUtil.lines((String)new StringWithPosition(content).position(position).result()));
            this.width = Math.max(this.lines.stream().mapToInt(String::length).max().orElse(0), title.length());
        }

        private String merge(SideText right, String title) {
            StringBuilder builder = new StringBuilder().append(title);
            this.fillToSameLines(right);
            right.fillToSameLines(this);
            String leftFormat = "%-" + this.width + "s";
            builder.append(String.format(leftFormat, this.title)).append(" | ").append(right.title).append('\n');
            this.appendHeadMinus(builder);
            builder.append("-|-");
            right.appendHeadMinus(builder);
            for (int i = 0; i < this.lines.size(); ++i) {
                builder.append('\n').append(String.format(leftFormat, this.lines.get(i))).append(" | ").append(right.lines.get(i));
            }
            return builder.toString().trim();
        }

        private void appendHeadMinus(StringBuilder builder) {
            for (int i = 0; i < this.width; ++i) {
                builder.append('-');
            }
        }

        private void fillToSameLines(SideText another) {
            for (int i = this.lines.size(); i < another.lines.size(); ++i) {
                this.lines.add("");
            }
        }
    }
}

