/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.binary.util;

import com.github.leeonky.dal.extensions.basic.CheckerType;
import com.github.leeonky.dal.extensions.basic.Diff;
import com.github.leeonky.dal.extensions.basic.binary.util.HexDumper;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.checker.Checker;
import com.github.leeonky.dal.runtime.checker.CheckingContext;
import com.github.leeonky.util.ConvertException;
import java.io.InputStream;
import java.util.Optional;

public abstract class HexChecker
implements Checker,
CheckerType {
    public static Optional<Checker> equals(Data d1, Data d2) {
        return Equals.INSTANCE;
    }

    public static Optional<Checker> matches(Data d1, Data d2) {
        return Matches.INSTANCE;
    }

    public String message(CheckingContext context) {
        return new Diff(this.getType(), context.getExpected().dumpAll(), context.getActual().dumpAll()).detail();
    }

    public Data transformExpected(Data expected, RuntimeContextBuilder.DALRuntimeContext context) {
        return context.wrap((Object)HexDumper.getBytes(expected));
    }

    public static class Matches
    extends HexChecker
    implements CheckerType.Matches {
        private static final Optional<Checker> INSTANCE = Optional.of(new Matches());

        public Data transformActual(Data actual, Data expected, RuntimeContextBuilder.DALRuntimeContext context) {
            return context.wrap((Object)HexDumper.getBytes(this.convert(actual)));
        }

        private Data convert(Data actual) {
            try {
                return actual.convert(byte[].class);
            }
            catch (ConvertException _ignore) {
                try {
                    return actual.convert(Byte[].class);
                }
                catch (ConvertException _ignore2) {
                    return actual.convert(InputStream.class);
                }
            }
        }
    }

    public static class Equals
    extends HexChecker
    implements CheckerType.Equals {
        private static final Optional<Checker> INSTANCE = Optional.of(new Equals());

        public Data transformActual(Data actual, Data expected, RuntimeContextBuilder.DALRuntimeContext context) {
            return context.wrap((Object)HexDumper.getBytes(actual));
        }
    }
}

