/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.binary.util;

import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.TextAttribute;
import com.github.leeonky.dal.runtime.TextFormatter;
import com.github.leeonky.interpreter.CharStream;
import com.github.leeonky.interpreter.Notation;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class HexFormatter
extends TextFormatter<String, byte[]> {
    private static byte[] parseBinary(String hexInText) {
        CharStream charStream = new CharStream(hexInText);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        while (charStream.trimBlackAndComment(Arrays.asList(Notation.notation((String)"#"))).hasContent()) {
            char c = charStream.popChar();
            if (c == ',') continue;
            if (charStream.hasContent()) {
                stream.write(Integer.parseInt(String.format("%c%c", Character.valueOf(c), Character.valueOf(charStream.popChar())), 16));
                continue;
            }
            throw new IllegalArgumentException(String.format("incomplete byte: %c, each byte should has 2 hex numbers", Character.valueOf(c)));
        }
        return stream.toByteArray();
    }

    public String description() {
        return "use hex numbers as binary data, like 'FF EF 08...'";
    }

    public byte[] format(String content, TextAttribute attribute, RuntimeContextBuilder.DALRuntimeContext context) {
        return HexFormatter.parseBinary(content);
    }
}

