/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.extensions.basic.file;

import com.github.leeonky.dal.DAL;
import com.github.leeonky.dal.extensions.basic.file.util.PathJavaClassPropertyAccessor;
import com.github.leeonky.dal.extensions.basic.file.util.ToString;
import com.github.leeonky.dal.extensions.basic.file.util.Util;
import com.github.leeonky.dal.runtime.CollectionDALCollection;
import com.github.leeonky.dal.runtime.DALCollection;
import com.github.leeonky.dal.runtime.DALCollectionFactory;
import com.github.leeonky.dal.runtime.Extension;
import com.github.leeonky.dal.runtime.PropertyAccessor;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.util.Suppressor;
import java.io.FileInputStream;
import java.nio.file.Path;

public class PathExtension
implements Extension {
    public void extend(DAL dal) {
        RuntimeContextBuilder runtimeContextBuilder = dal.getRuntimeContextBuilder();
        runtimeContextBuilder.registerImplicitData(Path.class, file -> (FileInputStream)Suppressor.get(() -> new FileInputStream(file.toFile()))).registerDALCollectionFactory(Path.class, (DALCollectionFactory)new DALCollectionFactory<Path, Path>(){

            public boolean isList(Path path) {
                return path.toFile().isDirectory();
            }

            public DALCollection<Path> create(Path path) {
                return new CollectionDALCollection(Util.listFile(path));
            }
        }).registerPropertyAccessor(Path.class, (PropertyAccessor)new PathJavaClassPropertyAccessor()).registerDumper(Path.class, data -> ((Path)data.instance()).toFile().isDirectory() ? Util.PATH_DIR_DUMPER : Util.PATH_FILE_DUMPER).getConverter().addTypeConverter(Path.class, String.class, ToString::name);
    }
}

